/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.IOException;
import java.io.OutputStream;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.EncodingUtils;
import org.w3c.tidy.Out;

public class OutImpl
implements Out {
    private int encoding;
    private int state;
    private OutputStream out;
    private EncodingUtils.PutBytes putBytes;
    private byte[] newline;

    public OutImpl(Configuration configuration, int encoding, OutputStream out) {
        this.encoding = encoding;
        this.state = 0;
        this.out = out;
        this.newline = new byte[configuration.newline.length];
        for (int j = 0; j < configuration.newline.length; ++j) {
            this.newline[j] = (byte)configuration.newline[j];
        }
        this.putBytes = new EncodingUtils.PutBytes(){
            private OutImpl impl;

            EncodingUtils.PutBytes setOut(OutImpl out) {
                this.impl = out;
                return this;
            }

            public void doPut(byte[] buf, int[] count) {
                this.impl.outcUTF8Bytes(buf, count);
            }
        }.setOut(this);
    }

    void outcUTF8Bytes(byte[] buf, int[] count) {
        try {
            for (int i = 0; i < count[0]; ++i) {
                this.out.write(buf[i]);
            }
        }
        catch (IOException e) {
            System.err.println("OutImpl.outcUTF8Bytes: " + e.toString());
        }
    }

    public void outc(byte c) {
        this.outc(c & 0xFF);
    }

    public void outc(int c) {
        block39: {
            try {
                if (this.encoding == 5) {
                    if (c < 128) {
                        this.out.write(c);
                        break block39;
                    }
                    for (int i = 128; i < 256; ++i) {
                        if (EncodingUtils.decodeMacRoman(i - 128) != c) continue;
                        this.out.write(i);
                        break block39;
                    }
                    break block39;
                }
                if (this.encoding == 9) {
                    if (c < 128 || c > 159 && c < 256) {
                        this.out.write(c);
                        break block39;
                    }
                    for (int i = 128; i < 160; ++i) {
                        if (EncodingUtils.decodeWin1252(i - 128) != c) continue;
                        this.out.write(i);
                        break block39;
                    }
                    break block39;
                }
                if (this.encoding == 3) {
                    int[] count = new int[]{0};
                    EncodingUtils.encodeCharToUTF8Bytes(c, null, this.putBytes, count);
                    if (count[0] <= 0) {
                        this.out.write(239);
                        this.out.write(191);
                        this.out.write(191);
                    }
                } else if (this.encoding == 4) {
                    if (c == 27) {
                        this.state = 1;
                    } else {
                        switch (this.state) {
                            case 1: {
                                if (c == 36) {
                                    this.state = 2;
                                    break;
                                }
                                if (c == 40) {
                                    this.state = 4;
                                    break;
                                }
                                this.state = 0;
                                break;
                            }
                            case 2: {
                                if (c == 40) {
                                    this.state = 3;
                                    break;
                                }
                                this.state = 5;
                                break;
                            }
                            case 3: {
                                this.state = 5;
                                break;
                            }
                            case 4: {
                                this.state = 0;
                                break;
                            }
                            case 5: {
                                c &= 0x7F;
                                break;
                            }
                        }
                    }
                    this.out.write(c);
                } else if (this.encoding == 6 || this.encoding == 7 || this.encoding == 8) {
                    int i = 1;
                    int numChars = 1;
                    int[] theChars = new int[2];
                    if (c > 0x10FFFF) {
                        c = 0;
                        numChars = 0;
                    } else if (c >= 65536) {
                        if ((c & 0xFFFE) == 65534 || (c & 0xFFFF) == 65535) {
                            c = 0;
                            numChars = 0;
                        } else {
                            theChars[0] = (c - 65536) / 1024 + 55296;
                            theChars[1] = (c - 65536) % 1024 + 56320;
                            numChars = 2;
                        }
                    } else {
                        theChars[0] = c;
                    }
                    for (i = 0; i < numChars; ++i) {
                        int ch;
                        c = theChars[i];
                        if (this.encoding == 6) {
                            ch = c & 0xFF;
                            this.out.write(ch);
                            ch = c >> 8 & 0xFF;
                            this.out.write(ch);
                            continue;
                        }
                        if (this.encoding != 7 && this.encoding != 8) continue;
                        ch = c >> 8 & 0xFF;
                        this.out.write(ch);
                        ch = c & 0xFF;
                        this.out.write(ch);
                    }
                } else if (this.encoding == 10 || this.encoding == 11) {
                    if (c < 128) {
                        this.out.write(c);
                    } else {
                        int ch = c >> 8 & 0xFF;
                        this.out.write(ch);
                        ch = c & 0xFF;
                        this.out.write(ch);
                    }
                } else {
                    this.out.write(c);
                }
            }
            catch (IOException e) {
                System.err.println("OutImpl.outc: " + e.toString());
            }
        }
    }

    public void newline() {
        try {
            this.out.write(this.newline);
            this.out.flush();
        }
        catch (IOException e) {
            System.err.println("OutImpl.newline: " + e.toString());
        }
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public void outBOM() {
        if (this.encoding == 3 || this.encoding == 6 || this.encoding == 7 || this.encoding == 8) {
            this.outc(65279);
        }
    }

    public void close() {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (IOException e) {
            System.err.println("OutImpl.close: " + e.toString());
        }
    }
}

