/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.util.file.ArchiveBrowser;

public class JarArchiveBrowser
implements Iterator {
    ZipFile zip;
    Enumeration entries;
    ZipEntry next;
    ArchiveBrowser.Filter filter;

    public JarArchiveBrowser(File file, ArchiveBrowser.Filter filter) {
        this.filter = filter;
        try {
            this.zip = new ZipFile(file);
            this.entries = this.zip.entries();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.setNext();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    private void setNext() {
        this.next = null;
        while (this.entries.hasMoreElements() && this.next == null) {
            do {
                this.next = (ZipEntry)this.entries.nextElement();
            } while (this.entries.hasMoreElements() && this.next.isDirectory());
            if (this.next.isDirectory()) {
                this.next = null;
            }
            if (this.next == null || this.filter.accept(this.next.getName())) continue;
            this.next = null;
        }
    }

    public Object next() {
        ZipEntry zipEntry = this.next;
        this.setNext();
        try {
            return this.zip.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void remove() {
        throw new RuntimeException("Illegal operation on ArchiveBrowser");
    }
}

