/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.vfs.spi.VirtualFile;
import org.jboss.vfs.spi.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileEntry
implements VirtualFile {
    private JarEntry entry;
    private JarFile jar;
    private URL jarURL;
    private String vfsPath;
    private InputStream entryIS;

    JarFileEntry(URL jarURL, String jarVfsPath, JarEntry entry, JarFile jar) {
        this.jarURL = jarURL;
        this.entry = entry;
        this.jar = jar;
        this.vfsPath = jarVfsPath.length() == 0 ? entry.getName() : jarVfsPath + "/" + entry.getName();
    }

    @Override
    public String getName() {
        return this.entry.getName();
    }

    @Override
    public String getPathName() {
        return this.vfsPath;
    }

    @Override
    public VirtualFile[] getChildren() {
        return new VirtualFile[0];
    }

    @Override
    public List<VirtualFile> getChildrenRecursively() throws IOException {
        return new ArrayList<VirtualFile>();
    }

    @Override
    public List<VirtualFile> getChildrenRecursively(VirtualFileFilter filter) throws IOException {
        return new ArrayList<VirtualFile>();
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public VirtualFile findChild(String name) throws IOException {
        throw new FileNotFoundException("JarFileEntry(" + this.entry.getName() + ") has no children");
    }

    @Override
    public long getLastModified() {
        return this.entry.getTime();
    }

    @Override
    public long getSize() {
        return this.entry.getSize();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public InputStream openStream() throws IOException {
        this.entryIS = this.jar.getInputStream(this.entry);
        return this.entryIS;
    }

    @Override
    public void close() throws IOException {
        if (this.entryIS != null) {
            this.entryIS.close();
        }
    }

    @Override
    public URL toURL() throws MalformedURLException {
        URL entryURL = new URL("jar:" + this.jarURL.toString() + "!/" + this.entry.getName());
        return entryURL;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(super.toString());
        tmp.append('[');
        tmp.append("name=");
        tmp.append(this.entry.getName());
        tmp.append(",size=");
        tmp.append(this.entry.getSize());
        tmp.append(",time=");
        tmp.append(this.entry.getTime());
        tmp.append(",URL=");
        try {
            tmp.append(this.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        tmp.append(']');
        return tmp.toString();
    }
}

