/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.system.ListenerServiceMBean;
import org.jboss.system.NotificationFilterFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ListenerServiceMBeanSupport
extends ServiceMBeanSupport
implements ListenerServiceMBean,
NotificationListener {
    private List sublist;
    private Element xmllist;
    private boolean dynamicSubscriptions;
    private ObjectName listener;
    private Object myHandback;
    private NotificationFilterSupport myFilter;

    public ListenerServiceMBeanSupport() {
        this.init();
    }

    public ListenerServiceMBeanSupport(Class type) {
        super(type);
        this.init();
    }

    public ListenerServiceMBeanSupport(String category) {
        super(category);
        this.init();
    }

    public ListenerServiceMBeanSupport(Logger log) {
        super(log);
        this.init();
    }

    public void setSubscriptionList(Element list) {
        this.xmllist = (Element)list.cloneNode(true);
    }

    public void subscribe(boolean dynamicSubscriptions) throws Exception {
        this.subscribe(dynamicSubscriptions, this.getServiceName());
    }

    public void subscribe(boolean dynamicSubscriptions, ObjectName listener) throws Exception {
        if (this.xmllist != null) {
            this.log.debug("Parsing subscription specification");
            ArrayList subscriptionList = this.parseXMLSubscriptionSpec(this.xmllist);
            this.subscribe(subscriptionList, dynamicSubscriptions, listener);
        } else {
            this.log.debug("Subscription specification not provided");
        }
    }

    public void subscribe(List subscriptionList, boolean dynamicSubscriptions, ObjectName listener) throws Exception {
        if (this.sublist != null) {
            return;
        }
        if (subscriptionList != null) {
            this.sublist = subscriptionList;
            this.dynamicSubscriptions = dynamicSubscriptions;
            this.listener = listener;
            this.log.debug(this.sublist);
            this.log.debug("Subscribing for JMX notifications, dynamic=" + dynamicSubscriptions + (this.getServiceName().equals(listener) ? "" : ", listener='" + listener + "'"));
            this.bulkRegister();
            if (dynamicSubscriptions) {
                this.getServer().addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this.getServiceName(), (NotificationFilter)this.myFilter, this.myHandback);
                this.log.debug("Subscribed to MBeanServerDelegate, too");
            }
        } else {
            this.log.debug("Subscription list not provided");
        }
    }

    public void unsubscribe() {
        if (this.sublist == null) {
            return;
        }
        this.log.debug("Removing all JMX notification subscriptions");
        this.bulkUnregister();
        if (this.dynamicSubscriptions) {
            try {
                this.getServer().removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this.getServiceName(), (NotificationFilter)this.myFilter, this.myHandback);
                this.log.debug("Unsubscribed from MBeanServerDelegate, too");
            }
            catch (MalformedObjectNameException e) {
                this.log.warn("Could not convert 'JMImplementation:type=MBeanServerDelegate' to ObjectName", e);
            }
            catch (InstanceNotFoundException e) {
                this.log.warn("Could not unsubscribe from non-existent MBeanServerDelegate!", e);
            }
            catch (ListenerNotFoundException e) {
                this.log.warn("Could not unsubscribe from MBeanServerDelegate", e);
            }
        }
        this.sublist = null;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (this.dynamicSubscriptions && handback == this.myHandback) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("It's for me: " + notification + ", handback:" + handback);
            }
            String type = notification.getType();
            ObjectName target = null;
            try {
                target = ((MBeanServerNotification)notification).getMBeanName();
            }
            catch (ClassCastException e) {
                this.log.warn("MBeanServer sent unknown notification class type: " + notification.getClass().getName());
                return;
            }
            if (type.equals("JMX.mbean.registered")) {
                for (SubscriptionInfo mbeanInfo : this.sublist) {
                    ObjectName objectName = mbeanInfo.getObjectName();
                    try {
                        if (!objectName.apply(target)) continue;
                        this.log.debug("ObjectName: '" + target + "' matched '" + objectName + "'");
                        this.singleRegister(this.getServer(), target, this.listener, mbeanInfo.getFilter(), mbeanInfo.getHandback());
                    }
                    catch (Exception e) {
                        this.log.warn("Caught exception from ObjectName.apply(" + target + ")", e);
                    }
                }
            } else {
                this.log.warn("Got unknown notification type from MBeanServerDelegate: " + type);
            }
        } else {
            this.handleNotification2(notification, handback);
        }
    }

    public void handleNotification2(Notification notification, Object handback) {
    }

    private void init() {
        this.myHandback = new Integer(Integer.MAX_VALUE);
        this.myFilter = new NotificationFilterSupport();
        this.myFilter.enableType("JMX.mbean.registered");
    }

    private void singleRegister(MBeanServer server, ObjectName target, ObjectName listener, NotificationFilter filter, Object handback) {
        try {
            server.addNotificationListener(target, listener, filter, handback);
            this.logSubscription(target, listener, handback, filter);
        }
        catch (InstanceNotFoundException e) {
            this.log.debug("Could not subscribe to: '" + target + "', target or listener MBean not registered");
        }
        catch (RuntimeException e) {
            this.log.warn("Failed to subscribe to: '" + target + "', maybe not a notification broadcaster or: '" + listener + "', maybe not a notification listener");
        }
    }

    private void singleUnregister(MBeanServer server, ObjectName target, ObjectName listener, NotificationFilter filter, Object handback) {
        try {
            server.removeNotificationListener(target, listener, filter, handback);
            this.log.debug("Unsubscribed from: '" + target + "'");
        }
        catch (InstanceNotFoundException e) {
            this.log.debug("Could not unsubscribe from non-existent: '" + target + "'");
        }
        catch (ListenerNotFoundException e) {
            this.log.debug("Could not unsubscribe from: '" + target + "'");
        }
        catch (RuntimeException e) {
            this.log.debug("Could not unsubscribe from: '" + target + "'");
        }
    }

    private void bulkRegister() {
        Iterator i = this.sublist.iterator();
        MBeanServer server = this.getServer();
        while (i.hasNext()) {
            SubscriptionInfo mbeanInfo = (SubscriptionInfo)i.next();
            ObjectName objectName = mbeanInfo.getObjectName();
            Object handback = mbeanInfo.getHandback();
            NotificationFilter filter = mbeanInfo.getFilter();
            if (objectName.isPattern()) {
                Set mset = server.queryNames(objectName, null);
                this.log.debug("ObjectName: '" + objectName + "' matched " + mset.size() + " MBean(s)");
                Iterator j = mset.iterator();
                while (j.hasNext()) {
                    this.singleRegister(server, (ObjectName)j.next(), this.listener, filter, handback);
                }
                continue;
            }
            this.singleRegister(server, objectName, this.listener, filter, handback);
        }
    }

    private void bulkUnregister() {
        Iterator i = this.sublist.iterator();
        MBeanServer server = this.getServer();
        while (i.hasNext()) {
            SubscriptionInfo mbeanInfo = (SubscriptionInfo)i.next();
            ObjectName objectName = mbeanInfo.getObjectName();
            Object handback = mbeanInfo.getHandback();
            NotificationFilter filter = mbeanInfo.getFilter();
            if (objectName.isPattern()) {
                Set mset = server.queryNames(objectName, null);
                this.log.debug("ObjectName: '" + objectName + "' matched " + mset.size() + " MBean(s)");
                Iterator j = mset.iterator();
                while (j.hasNext()) {
                    this.singleUnregister(server, (ObjectName)j.next(), this.listener, filter, handback);
                }
                continue;
            }
            this.singleUnregister(server, objectName, this.listener, filter, handback);
        }
    }

    private void logSubscription(ObjectName objectName, ObjectName listener, Object handback, NotificationFilter filter) {
        StringBuffer sbuf = new StringBuffer(100);
        sbuf.append("Subscribed to: { objectName='").append(objectName);
        sbuf.append("', listener='").append(listener);
        sbuf.append("', handback=").append(handback);
        sbuf.append(", filter=");
        sbuf.append(filter == null ? null : filter.toString());
        sbuf.append(" }");
        this.log.debug(sbuf.toString());
    }

    private NotificationFilter createNotificationFilter(String factoryClass, Element filterConfig) throws Exception {
        NotificationFilterFactory factory;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryClass);
            factory = (NotificationFilterFactory)clazz.newInstance();
        }
        catch (Exception e) {
            try {
                factoryClass = "org.jboss.system.filterfactory." + factoryClass;
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryClass);
                factory = (NotificationFilterFactory)clazz.newInstance();
            }
            catch (Exception inner) {
                throw e;
            }
        }
        return factory.createNotificationFilter(filterConfig);
    }

    private ArrayList parseXMLSubscriptionSpec(Element root) throws Exception {
        ArrayList<SubscriptionInfo> slist = new ArrayList<SubscriptionInfo>();
        if (!root.getNodeName().equals("subscription-list")) {
            throw new Exception("Expected 'subscription-list' element, got: '" + root.getNodeName() + "'");
        }
        NodeList rootlist = root.getChildNodes();
        for (int i = 0; i < rootlist.getLength(); ++i) {
            Node mbean = rootlist.item(i);
            if (!mbean.getNodeName().equals("mbean")) continue;
            String name = null;
            if (!((Element)mbean).hasAttribute("name")) {
                throw new Exception("'mbean' element must have a 'name' attribute");
            }
            name = ((Element)mbean).getAttribute("name");
            String handback = null;
            if (((Element)mbean).hasAttribute("handback")) {
                handback = ((Element)mbean).getAttribute("handback");
            }
            ObjectName objectName = new ObjectName(name);
            NotificationFilter filter = null;
            NodeList mbeanChildren = mbean.getChildNodes();
            for (int j = 0; j < mbeanChildren.getLength(); ++j) {
                Node mbeanChildNode = mbeanChildren.item(j);
                if (!mbeanChildNode.getNodeName().equals("filter")) continue;
                String factory = null;
                if (((Element)mbeanChildNode).hasAttribute("factory")) {
                    factory = ((Element)mbeanChildNode).getAttribute("factory");
                    filter = this.createNotificationFilter(factory, (Element)mbeanChildNode);
                    break;
                }
                throw new Exception("'filter' element must have a 'factory' attribute");
            }
            if (filter == null) {
                ArrayList<String> tmplist = new ArrayList<String>(mbeanChildren.getLength());
                for (int j = 0; j < mbeanChildren.getLength(); ++j) {
                    Node mbeanChildNode = mbeanChildren.item(j);
                    if (!mbeanChildNode.getNodeName().equals("notification")) continue;
                    String type = null;
                    if (((Element)mbeanChildNode).hasAttribute("type")) {
                        type = ((Element)mbeanChildNode).getAttribute("type");
                        tmplist.add(type);
                        continue;
                    }
                    throw new Exception("'notification' element must have a 'type' attribute");
                }
                if (tmplist.size() > 0) {
                    NotificationFilterSupport sfilter = new NotificationFilterSupport();
                    for (int j = 0; j < tmplist.size(); ++j) {
                        sfilter.enableType((String)tmplist.get(j));
                    }
                    filter = sfilter;
                }
            }
            slist.add(new SubscriptionInfo(objectName, handback, filter));
        }
        return slist;
    }

    public static final class SubscriptionInfo {
        private ObjectName objectName;
        private Object handback;
        private NotificationFilter filter;

        public SubscriptionInfo(ObjectName objectName, Object handback, NotificationFilter filter) {
            this.objectName = objectName;
            this.handback = handback;
            this.filter = filter;
        }

        public ObjectName getObjectName() {
            return this.objectName;
        }

        public Object getHandback() {
            return this.handback;
        }

        public NotificationFilter getFilter() {
            return this.filter;
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer(100);
            sbuf.append("SubscriptionInfo { objectName='").append(this.objectName);
            sbuf.append("', handback=").append(this.handback);
            sbuf.append(", filter=");
            sbuf.append(this.filter == null ? null : this.filter.toString());
            sbuf.append(" }");
            return sbuf.toString();
        }
    }
}

