/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.loader;

import org.jboss.metadata.spi.loader.MetaDataLoader;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.Item;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDatasItem;
import org.jboss.metadata.spi.retrieval.ValidTime;
import org.jboss.metadata.spi.retrieval.helper.AnnotationToMetaDataBridge;
import org.jboss.metadata.spi.retrieval.helper.AnnotationsToMetaDatasBridge;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetaDataLoader
implements MetaDataLoader {
    private ValidTime validTime;
    private ScopeKey scopeKey;

    public AbstractMetaDataLoader() {
        this(ScopeKey.DEFAULT_SCOPE);
    }

    public AbstractMetaDataLoader(ScopeKey key) {
        this.scopeKey = key;
        this.validTime = new ValidTime();
    }

    @Override
    public ScopeKey getScope() {
        return this.scopeKey;
    }

    @Override
    public ValidTime getValidTime() {
        return this.validTime;
    }

    @Override
    public <T> boolean isCachable(Item<T> item) {
        return true;
    }

    @Override
    public AnnotationsItem retrieveLocalAnnotations() {
        return this.retrieveAnnotations();
    }

    @Override
    public <T> MetaDataItem<T> retrieveMetaData(Class<T> type) {
        if (!type.isAnnotation()) {
            return null;
        }
        AnnotationItem<T> annotation = this.retrieveAnnotation(type);
        if (annotation == null) {
            return null;
        }
        return new AnnotationToMetaDataBridge(annotation);
    }

    @Override
    public MetaDatasItem retrieveLocalMetaData() {
        return this.retrieveMetaData();
    }

    @Override
    public MetaDatasItem retrieveMetaData() {
        AnnotationsItem annotations = this.retrieveAnnotations();
        return new AnnotationsToMetaDatasBridge(annotations);
    }

    public void invalidate() {
        this.validTime.invalidate();
    }
}

