/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.xml.rpc.handler.MessageContext;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.StatelessSessionContainer;
import org.jboss.ejb.StatelessSessionEnterpriseContext;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.EnterpriseBeanPolicyContextHandler;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.InvocationType;

public class StatelessSessionInstanceInterceptor
extends AbstractInterceptor {
    protected StatelessSessionContainer container;
    protected static final Method ejbTimeout;

    public void setContainer(Container container) {
        super.setContainer(container);
        this.container = (StatelessSessionContainer)container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeHome(Invocation mi) throws Exception {
        InstancePool pool = this.container.getInstancePool();
        StatelessSessionEnterpriseContext ctx = null;
        try {
            ctx = (StatelessSessionEnterpriseContext)pool.get();
            mi.setEnterpriseContext(ctx);
            Object object = this.getNext().invokeHome(mi);
            return object;
        }
        finally {
            mi.setEnterpriseContext(null);
            if (ctx != null) {
                pool.free(ctx);
            }
        }
    }

    public Object invoke(Invocation mi) throws Exception {
        InstancePool pool = this.container.getInstancePool();
        StatelessSessionEnterpriseContext ctx = null;
        try {
            ctx = (StatelessSessionEnterpriseContext)pool.get();
        }
        catch (EJBException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            boolean isLocal;
            InvocationType type = mi.getType();
            boolean bl = isLocal = type == InvocationType.LOCAL || type == InvocationType.LOCALHOME;
            if (isLocal) {
                throw new EJBException("Unable to get an instance from the pool", e);
            }
            throw new RemoteException("Unable to get an intance from the pool", e);
        }
        ctx.setPrincipal(mi.getPrincipal());
        EnterpriseBeanPolicyContextHandler.setEnterpriseBean(ctx.getInstance());
        mi.setEnterpriseContext(ctx);
        Object msgContext = mi.getValue(InvocationKey.SOAP_MESSAGE_CONTEXT);
        if (ejbTimeout.equals(mi.getMethod())) {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_TIMEOUT);
        } else if (msgContext != null) {
            if (msgContext instanceof MessageContext) {
                ctx.setMessageContext((MessageContext)msgContext);
            }
            AllowedOperationsAssociation.pushInMethodFlag(IN_SERVICE_ENDPOINT_METHOD);
        } else {
            AllowedOperationsAssociation.pushInMethodFlag(IN_BUSINESS_METHOD);
        }
        try {
            Object obj;
            Object object = obj = this.getNext().invoke(mi);
            return object;
        }
        catch (RuntimeException e) {
            mi.setEnterpriseContext(null);
            throw e;
        }
        catch (RemoteException e) {
            mi.setEnterpriseContext(null);
            throw e;
        }
        catch (Error e) {
            mi.setEnterpriseContext(null);
            throw e;
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
            if (mi.getEnterpriseContext() != null) {
                pool.free((EnterpriseContext)mi.getEnterpriseContext());
            } else {
                pool.discard(ctx);
            }
        }
    }

    static {
        try {
            ejbTimeout = TimedObject.class.getMethod("ejbTimeout", Timer.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

