/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.J2eeModuleMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.SecurityRoleMetaData;
import org.jboss.mx.util.MBeanServerLocator;
import org.w3c.dom.Element;

public class J2eeApplicationMetaData
extends MetaData {
    private String displayName;
    private String description;
    private String smallIcon;
    private String largeIcon;
    private String libDirName = "lib";
    private String version;
    private HashMap securityRoles = new HashMap();
    private String securityDomain;
    private String unauthenticatedPrincipal;
    private Map modules = new LinkedHashMap();
    private String jmxName;

    public String getVersion() {
        return this.version;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public Iterator getModules() {
        return this.modules.values().iterator();
    }

    public boolean hasModule(String name) {
        return this.modules.containsKey(name);
    }

    public Map getSecurityRoles() {
        return new HashMap(this.securityRoles);
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public String getUnauthenticatedPrincipal() {
        return this.unauthenticatedPrincipal;
    }

    public String getJMXName() {
        return this.jmxName;
    }

    public String getLibraryDirectory() {
        return this.libDirName;
    }

    public void addModule(J2eeModuleMetaData moduleMetaData) {
        this.modules.put(moduleMetaData.getFileName(), moduleMetaData);
    }

    public void importXml(Element rootElement) throws DeploymentException {
        String rootTag = rootElement.getOwnerDocument().getDocumentElement().getTagName();
        if (rootTag.equals("application")) {
            this.importApplicationXml(rootElement);
        } else if (rootTag.equals("jboss-app")) {
            this.importJBossAppXml(rootElement);
        } else {
            throw new DeploymentException("Unrecognized root tag: " + rootTag);
        }
    }

    protected void importApplicationXml(Element rootElement) throws DeploymentException {
        this.version = J2eeApplicationMetaData.getElementAttribute(rootElement, "version");
        this.displayName = MetaData.getOptionalChildContent(rootElement, "display-name", "");
        Element descrElement = J2eeApplicationMetaData.getOptionalChild(rootElement, "description");
        this.description = descrElement != null ? J2eeApplicationMetaData.getElementContent(descrElement) : "";
        Element iconElement = J2eeApplicationMetaData.getOptionalChild(rootElement, "icon");
        if (iconElement != null) {
            Element element = J2eeApplicationMetaData.getOptionalChild(iconElement, "small-icon");
            this.smallIcon = element != null ? J2eeApplicationMetaData.getElementContent(element) : "";
            element = J2eeApplicationMetaData.getOptionalChild(iconElement, "large-icon");
            this.largeIcon = element != null ? J2eeApplicationMetaData.getElementContent(element) : "";
        } else {
            this.smallIcon = "";
            this.largeIcon = "";
        }
        this.libDirName = J2eeApplicationMetaData.getOptionalChildContent(rootElement, "library-directory", "lib");
        if (this.libDirName != null && this.libDirName.length() == 0) {
            this.libDirName = null;
        }
        Iterator it = J2eeApplicationMetaData.getChildrenByTagName(rootElement, "module");
        while (it.hasNext()) {
            J2eeModuleMetaData moduleMetaData = new J2eeModuleMetaData();
            moduleMetaData.importXml((Element)it.next());
            this.addModule(moduleMetaData);
        }
    }

    protected void importJBossAppXml(Element rootElement) throws DeploymentException {
        Element unauth;
        Element securityDomainElement = J2eeApplicationMetaData.getOptionalChild(rootElement, "security-domain");
        if (securityDomainElement != null) {
            this.securityDomain = J2eeApplicationMetaData.getElementContent(securityDomainElement);
        }
        if ((unauth = J2eeApplicationMetaData.getOptionalChild(rootElement, "unauthenticated-principal")) != null) {
            this.unauthenticatedPrincipal = J2eeApplicationMetaData.getElementContent(unauth);
        } else {
            try {
                MBeanServer server = MBeanServerLocator.locateJBoss();
                ObjectName oname = new ObjectName("jboss.security:service=JaasSecurityManager");
                this.unauthenticatedPrincipal = (String)server.getAttribute(oname, "DefaultUnauthenticatedPrincipal");
            }
            catch (Exception e) {
                log.error("Cannot obtain unauthenticated principal");
            }
        }
        Iterator iterator = J2eeApplicationMetaData.getChildrenByTagName(rootElement, "security-role");
        while (iterator.hasNext()) {
            Element securityRole = (Element)iterator.next();
            String roleName = J2eeApplicationMetaData.getElementContent(J2eeApplicationMetaData.getUniqueChild(securityRole, "role-name"));
            SecurityRoleMetaData srMetaData = new SecurityRoleMetaData(roleName);
            Iterator itPrincipalNames = J2eeApplicationMetaData.getChildrenByTagName(securityRole, "principal-name");
            while (itPrincipalNames.hasNext()) {
                String principalName = J2eeApplicationMetaData.getElementContent((Element)itPrincipalNames.next());
                srMetaData.addPrincipalName(principalName);
            }
            this.securityRoles.put(roleName, srMetaData);
        }
        Element jmxNameElement = J2eeApplicationMetaData.getOptionalChild(rootElement, "jmx-name");
        if (jmxNameElement != null) {
            this.jmxName = J2eeApplicationMetaData.getElementContent(jmxNameElement);
        }
        Iterator it = J2eeApplicationMetaData.getChildrenByTagName(rootElement, "module");
        while (it.hasNext()) {
            J2eeModuleMetaData moduleMetaData = new J2eeModuleMetaData();
            moduleMetaData.importXml((Element)it.next());
            this.addModule(moduleMetaData);
        }
    }
}

