/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.deployers.spi.DeploymentSorter;
import org.jboss.deployers.vdf.spi.VDFComponent;

public class SuffixSorter
implements DeploymentSorter {
    protected String[] suffixes = new String[0];
    protected ArrayList suffixEntries = new ArrayList();

    public static String[] stripOrder(String[] enhancedSuffixes) {
        String[] suffixes = new String[enhancedSuffixes.length];
        for (int i = 0; i < enhancedSuffixes.length; ++i) {
            StringTokenizer tokenizer = new StringTokenizer(enhancedSuffixes[i], ":");
            if (tokenizer.countTokens() > 1) {
                tokenizer.nextToken();
            }
            suffixes[i] = tokenizer.nextToken();
        }
        return suffixes;
    }

    public String[] getSuffixes() {
        return this.suffixes;
    }

    public void addEnhancedSuffixes(String[] enhancedSuffixes) {
        if (enhancedSuffixes != null) {
            for (int i = 0; i < enhancedSuffixes.length; ++i) {
                this.addSuffix(new SuffixEntry(enhancedSuffixes[i]));
            }
            this.suffixes = this.produceSuffixes();
        }
    }

    public void removeEnhancedSuffixes(String[] enhancedSuffixes) {
        if (enhancedSuffixes != null) {
            for (int i = 0; i < enhancedSuffixes.length; ++i) {
                this.suffixEntries.remove(new SuffixEntry(enhancedSuffixes[i]));
            }
            this.suffixes = this.produceSuffixes();
        }
    }

    private String[] produceSuffixes() {
        String[] suffixes = new String[this.suffixEntries.size()];
        for (int i = 0; i < this.suffixEntries.size(); ++i) {
            suffixes[i] = ((SuffixEntry)this.suffixEntries.get((int)i)).suffix;
        }
        return suffixes;
    }

    private void addSuffix(SuffixEntry suffix) {
        int size = this.suffixEntries.size();
        if (size == 0) {
            this.suffixEntries.add(suffix);
        } else {
            for (int i = size - 1; i > -1; --i) {
                SuffixEntry entry = (SuffixEntry)this.suffixEntries.get(i);
                if (suffix.order >= entry.order) {
                    this.suffixEntries.add(i + 1, suffix);
                    break;
                }
                if (i != 0) continue;
                this.suffixEntries.add(0, suffix);
            }
        }
    }

    public int compare(Object o1, Object o2) {
        VDFComponent comp1 = (VDFComponent)o1;
        VDFComponent comp2 = (VDFComponent)o2;
        int order = this.getSuffixIndex(comp1) - this.getSuffixIndex(comp2);
        if (order != 0) {
            return order;
        }
        return comp1.getURI().getPath().compareTo(comp2.getURI().getPath());
    }

    private int getSuffixIndex(VDFComponent comp) {
        int i;
        String basename = comp.getBaseName();
        for (i = 0; i < this.suffixes.length && !basename.endsWith(this.suffixes[i]); ++i) {
        }
        return i;
    }

    private static class SuffixEntry {
        public String suffix;
        public int order;

        public SuffixEntry(String suffix, int order) {
            this.suffix = suffix;
            this.order = order;
        }

        public SuffixEntry(String enhancedSuffix) {
            StringTokenizer tokenizer = new StringTokenizer(enhancedSuffix, ":");
            int tokens = tokenizer.countTokens();
            switch (tokens) {
                case 1: {
                    this.order = 500;
                    this.suffix = enhancedSuffix;
                    break;
                }
                case 2: {
                    this.order = Integer.parseInt(tokenizer.nextToken());
                    this.suffix = tokenizer.nextToken();
                    break;
                }
                default: {
                    throw new RuntimeException("cannot parse enhancedSuffix: " + enhancedSuffix);
                }
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof SuffixEntry) {
                SuffixEntry se = (SuffixEntry)other;
                return se.suffix.equals(this.suffix) && se.order == this.order;
            }
            return false;
        }

        public int hashCode() {
            return 27 * this.order + this.suffix.hashCode();
        }

        public String toString() {
            return this.order + 58 + this.suffix;
        }
    }
}

