/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.plugins.AbstractTypeMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMapMetaData
extends AbstractTypeMetaData
implements Map<MetaDataVisitorNode, MetaDataVisitorNode> {
    private HashMap<MetaDataVisitorNode, MetaDataVisitorNode> map = new HashMap();
    protected String keyType;
    protected String valueType;

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    @Override
    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        Map<Object, Object> result = this.getMapInstance(info, cl, Map.class);
        if (result == null) {
            result = this.getDefaultMapInstance();
        }
        ClassInfo keyTypeInfo = this.getKeyClassInfo(cl);
        ClassInfo valueTypeInfo = this.getValueClassInfo(cl);
        if (this.map.size() > 0) {
            for (Map.Entry<MetaDataVisitorNode, MetaDataVisitorNode> entry : this.map.entrySet()) {
                ValueMetaData key = (ValueMetaData)entry.getKey();
                ValueMetaData value = (ValueMetaData)entry.getValue();
                Object keyValue = key.getValue(keyTypeInfo, cl);
                Object valueValue = value.getValue(valueTypeInfo, cl);
                result.put(keyValue, valueValue);
            }
        }
        return result;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<MetaDataVisitorNode, MetaDataVisitorNode>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public MetaDataVisitorNode get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<MetaDataVisitorNode> keySet() {
        return this.map.keySet();
    }

    @Override
    public MetaDataVisitorNode put(MetaDataVisitorNode key, MetaDataVisitorNode value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends MetaDataVisitorNode, ? extends MetaDataVisitorNode> t) {
        this.putAll(t);
    }

    @Override
    public MetaDataVisitorNode remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<MetaDataVisitorNode> values() {
        return this.map.values();
    }

    @Override
    public Iterator<? extends MetaDataVisitorNode> getChildren() {
        ArrayList<MetaDataVisitorNode> children = new ArrayList<MetaDataVisitorNode>(this.map.keySet());
        children.addAll(this.map.values());
        return children.iterator();
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
    }

    protected Map<Object, Object> getDefaultMapInstance() throws Throwable {
        return new HashMap<Object, Object>();
    }

    protected Map<Object, Object> getMapInstance(TypeInfo info, ClassLoader cl, Class<?> expected) throws Throwable {
        BeanInfo beanInfo;
        Joinpoint constructor;
        Object result;
        TypeInfo typeInfo = this.getClassInfo(cl);
        if (typeInfo != null && !(typeInfo instanceof ClassInfo)) {
            throw new IllegalArgumentException(typeInfo.getName() + " is not a class");
        }
        if (typeInfo != null && typeInfo.isInterface()) {
            throw new IllegalArgumentException(typeInfo.getName() + " is an interface");
        }
        if (typeInfo == null) {
            if (info == null) {
                return null;
            }
            if (!(info instanceof ClassInfo)) {
                return null;
            }
            if (((ClassInfo)info).isInterface()) {
                return null;
            }
            if (Object.class.getName().equals(info.getName())) {
                return null;
            }
            typeInfo = info;
        }
        if (!expected.isAssignableFrom((result = (constructor = this.configurator.getConstructorJoinPoint(beanInfo = this.configurator.getBeanInfo(typeInfo))).dispatch()).getClass())) {
            throw new ClassCastException(result.getClass() + " is not a " + expected.getName());
        }
        return (Map)result;
    }

    protected ClassInfo getKeyClassInfo(ClassLoader cl) throws Throwable {
        if (this.keyType == null) {
            return null;
        }
        return this.configurator.getClassInfo(this.keyType, cl);
    }

    protected ClassInfo getValueClassInfo(ClassLoader cl) throws Throwable {
        if (this.valueType == null) {
            return null;
        }
        return this.configurator.getClassInfo(this.valueType, cl);
    }
}

