/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.aop.Advised;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aspects.versioned.CollectionStateChangeInterceptor;
import org.jboss.aspects.versioned.DistributedFieldUpdate;
import org.jboss.aspects.versioned.DistributedListState;
import org.jboss.aspects.versioned.DistributedMapState;
import org.jboss.aspects.versioned.DistributedPOJOState;
import org.jboss.aspects.versioned.DistributedSetState;
import org.jboss.aspects.versioned.StateChangeInterceptor;
import org.jboss.aspects.versioned.StateManager;
import org.jboss.aspects.versioned.SynchronizationManager;
import org.jboss.aspects.versioned.VersionManager;
import org.jboss.aspects.versioned.VersionReference;
import org.jboss.logging.Logger;
import org.jboss.util.id.GUID;

public class DistributedVersionManager
extends VersionManager {
    protected static Logger log = Logger.getLogger(DistributedVersionManager.class);
    protected SynchronizationManager synchManager;
    protected long timeout;

    public DistributedVersionManager(long timeout, SynchronizationManager synchManager) {
        this.synchManager = synchManager;
        this.timeout = timeout;
    }

    public boolean isVersioned(Object obj) {
        if (!(obj instanceof InstanceAdvised)) {
            return false;
        }
        InstanceAdvised advised = (InstanceAdvised)obj;
        return DistributedVersionManager.getGUID(advised) != null;
    }

    public GUID tag(InstanceAdvised advised) {
        GUID guid = new GUID();
        SimpleMetaData metaData = advised._getInstanceAdvisor().getMetaData();
        metaData.addMetaData("VERSION_MANAGER", "VERSION_ID", guid);
        return guid;
    }

    public void untag(InstanceAdvised advised) {
        SimpleMetaData metaData = advised._getInstanceAdvisor().getMetaData();
        metaData.removeMetaData("VERSION_MANAGER", "VERSION_ID");
    }

    public List makeVersionedList(List list, ArrayList newObjects) throws Exception {
        ClassProxy proxy = ClassProxyFactory.newInstance(list.getClass());
        GUID guid = this.tag(proxy);
        DistributedListState manager = new DistributedListState(guid, this.timeout, proxy, list, this, this.synchManager);
        StateManager.setStateManager(proxy, manager);
        CollectionStateChangeInterceptor interceptor = new CollectionStateChangeInterceptor(manager);
        proxy._getInstanceAdvisor().appendInterceptor(interceptor);
        newObjects.add(manager);
        return (List)((Object)proxy);
    }

    public Map makeVersionedMap(Map map, ArrayList newObjects) throws Exception {
        ClassProxy proxy = ClassProxyFactory.newInstance(map.getClass());
        GUID guid = this.tag(proxy);
        DistributedMapState manager = new DistributedMapState(guid, this.timeout, proxy, map, this, this.synchManager);
        StateManager.setStateManager(proxy, manager);
        CollectionStateChangeInterceptor interceptor = new CollectionStateChangeInterceptor(manager);
        proxy._getInstanceAdvisor().appendInterceptor(interceptor);
        newObjects.add(manager);
        return (Map)((Object)proxy);
    }

    public Set makeVersionedSet(Set set, ArrayList newObjects) throws Exception {
        ClassProxy proxy = ClassProxyFactory.newInstance(set.getClass());
        GUID guid = this.tag(proxy);
        DistributedSetState manager = new DistributedSetState(guid, this.timeout, proxy, set, this, this.synchManager);
        StateManager.setStateManager(proxy, manager);
        CollectionStateChangeInterceptor interceptor = new CollectionStateChangeInterceptor(manager);
        proxy._getInstanceAdvisor().appendInterceptor(interceptor);
        newObjects.add(manager);
        return (Set)((Object)proxy);
    }

    public Object makeVersioned(Object obj) throws Exception {
        ArrayList newObjects = new ArrayList();
        obj = this.makeVersioned(obj, newObjects);
        this.synchManager.createObjects(newObjects);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object makeVersioned(Object obj, ArrayList newObjects) throws Exception {
        GUID guid;
        SimpleMetaData metaData;
        if (obj instanceof ClassProxy) {
            return obj;
        }
        if (!(obj instanceof Advised)) {
            if (obj instanceof List) {
                List list = (List)obj;
                return this.makeVersionedList(list, newObjects);
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                return this.makeVersionedMap(map, newObjects);
            }
            if (obj instanceof Set) {
                Set set = (Set)obj;
                return this.makeVersionedSet(set, newObjects);
            }
            return obj;
        }
        Advised advised = (Advised)obj;
        SimpleMetaData simpleMetaData = metaData = advised._getInstanceAdvisor().getMetaData();
        synchronized (simpleMetaData) {
            if (this.isVersioned(advised)) {
                return obj;
            }
            guid = this.tag(advised);
        }
        System.out.println("VersionManager: " + guid);
        DistributedPOJOState manager = new DistributedPOJOState(guid, this.timeout, advised, this, this.synchManager);
        StateManager.setStateManager(advised, manager);
        StateChangeInterceptor interceptor = new StateChangeInterceptor(manager);
        manager.acquireWriteLock();
        advised._getInstanceAdvisor().appendInterceptor(interceptor);
        try {
            Field[] advisedFields = ((ClassAdvisor)advised._getAdvisor()).getAdvisedFields();
            for (int i = 0; i < advisedFields.length; ++i) {
                Field field = advisedFields[i];
                if (Modifier.isStatic(field.getModifiers())) continue;
                Object fieldVal = field.get(advised);
                if (fieldVal != null) {
                    InstanceAdvised instanceAdvised;
                    if (fieldVal instanceof Advised) {
                        Advised fieldAdvised = (Advised)fieldVal;
                        this.makeVersioned(fieldAdvised, newObjects);
                        fieldVal = new VersionReference(DistributedVersionManager.getGUID(fieldAdvised), fieldAdvised);
                    } else if (fieldVal instanceof List) {
                        List list = (List)fieldVal;
                        instanceAdvised = (InstanceAdvised)((Object)this.makeVersionedList(list, newObjects));
                        fieldVal = new VersionReference(DistributedVersionManager.getGUID(instanceAdvised), instanceAdvised);
                    } else if (fieldVal instanceof Map) {
                        Map map = (Map)fieldVal;
                        instanceAdvised = (InstanceAdvised)((Object)this.makeVersionedMap(map, newObjects));
                        fieldVal = new VersionReference(DistributedVersionManager.getGUID(instanceAdvised), instanceAdvised);
                    } else if (fieldVal instanceof Set) {
                        Set set = (Set)fieldVal;
                        instanceAdvised = (InstanceAdvised)((Object)this.makeVersionedSet(set, newObjects));
                        fieldVal = new VersionReference(DistributedVersionManager.getGUID(instanceAdvised), instanceAdvised);
                    }
                }
                manager.fieldMap.put(new Integer(i), new DistributedFieldUpdate(fieldVal, 0L, i));
            }
            newObjects.add(manager);
            Advised advised2 = advised;
            return advised2;
        }
        finally {
            manager.releaseWriteLock();
        }
    }

    public void addVersioning(DistributedPOJOState manager, Advised advised) {
        StateManager.setStateManager(advised, manager);
        StateChangeInterceptor interceptor = new StateChangeInterceptor(manager);
        SimpleMetaData metaData = advised._getInstanceAdvisor().getMetaData();
        metaData.addMetaData("VERSION_MANAGER", "VERSION_ID", manager.getGUID());
        advised._getInstanceAdvisor().appendInterceptor(interceptor);
    }

    public ClassProxy addListVersioning(List list, DistributedListState manager) throws Exception {
        ClassProxy proxy = ClassProxyFactory.newInstance(list.getClass());
        GUID guid = manager.getGUID();
        SimpleMetaData metaData = proxy._getInstanceAdvisor().getMetaData();
        metaData.addMetaData("VERSION_MANAGER", "VERSION_ID", guid);
        StateManager.setStateManager(proxy, manager);
        CollectionStateChangeInterceptor interceptor = new CollectionStateChangeInterceptor(manager);
        proxy._getInstanceAdvisor().appendInterceptor(interceptor);
        return proxy;
    }

    public ClassProxy addMapVersioning(Map map, DistributedMapState manager) throws Exception {
        ClassProxy proxy = ClassProxyFactory.newInstance(map.getClass());
        GUID guid = manager.getGUID();
        SimpleMetaData metaData = proxy._getInstanceAdvisor().getMetaData();
        metaData.addMetaData("VERSION_MANAGER", "VERSION_ID", guid);
        StateManager.setStateManager(proxy, manager);
        CollectionStateChangeInterceptor interceptor = new CollectionStateChangeInterceptor(manager);
        proxy._getInstanceAdvisor().appendInterceptor(interceptor);
        return proxy;
    }

    public ClassProxy addSetVersioning(Set set, DistributedSetState manager) throws Exception {
        ClassProxy proxy = ClassProxyFactory.newInstance(set.getClass());
        GUID guid = manager.getGUID();
        SimpleMetaData metaData = proxy._getInstanceAdvisor().getMetaData();
        metaData.addMetaData("VERSION_MANAGER", "VERSION_ID", guid);
        StateManager.setStateManager(proxy, manager);
        CollectionStateChangeInterceptor interceptor = new CollectionStateChangeInterceptor(manager);
        proxy._getInstanceAdvisor().appendInterceptor(interceptor);
        return proxy;
    }
}

