/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.security.Exclude;
import org.jboss.aspects.security.Permissions;
import org.jboss.aspects.security.SecurityActions;
import org.jboss.aspects.security.Unchecked;
import org.jboss.logging.Logger;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SimplePrincipal;

public class RoleBasedAuthorizationInterceptor
implements Interceptor {
    protected Logger log = Logger.getLogger(this.getClass());
    protected AuthenticationManager securityManager;
    protected RealmMapping realmMapping;

    public RoleBasedAuthorizationInterceptor(AuthenticationManager manager, RealmMapping realmMapping) {
        this.securityManager = manager;
        this.realmMapping = realmMapping;
    }

    public String getName() {
        return "RoleBasedAuthorizationInterceptor";
    }

    protected Set getRoleSet(Invocation invocation) {
        Set roles = (Set)invocation.getMetaData("security", "roles");
        if (roles == null) {
            roles = this.getAnnotationRoleSet(invocation);
        }
        return roles;
    }

    protected Set getAnnotationRoleSet(Invocation invocation) {
        HashSet<Object> set = new HashSet<Object>();
        Exclude exclude = (Exclude)invocation.resolveAnnotation(Exclude.class);
        if (exclude != null) {
            set.add(NobodyPrincipal.NOBODY_PRINCIPAL);
            return set;
        }
        Unchecked unchecked = (Unchecked)invocation.resolveAnnotation(Unchecked.class);
        if (unchecked != null) {
            set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
            return set;
        }
        Permissions permissions = (Permissions)invocation.resolveAnnotation(Permissions.class);
        if (permissions == null) {
            set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
            return set;
        }
        for (int i = 0; i < permissions.value().length; ++i) {
            set.add(new SimplePrincipal(permissions.value()[i]));
        }
        return set;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.securityManager == null) {
            return invocation.invokeNext();
        }
        if (this.realmMapping == null) {
            throw new SecurityException("Role mapping manager has not been set");
        }
        Set roles = this.getRoleSet(invocation);
        if (roles == null) {
            String message = "No method permissions assigned.";
            this.log.error(message);
            throw new SecurityException(message);
        }
        RunAsIdentity callerRunAsIdentity = SecurityActions.peekRunAsIdentity();
        if (!roles.contains(AnybodyPrincipal.ANYBODY_PRINCIPAL)) {
            if (callerRunAsIdentity == null) {
                Principal principal = SecurityActions.getPrincipal();
                if (!this.realmMapping.doesUserHaveRole(principal, roles)) {
                    Set userRoles = this.realmMapping.getUserRoles(principal);
                    String msg = "Insufficient permissions, principal=" + principal + ", requiredRoles=" + roles + ", principalRoles=" + userRoles;
                    this.log.error(msg);
                    throw new SecurityException(msg);
                }
            } else if (!callerRunAsIdentity.doesUserHaveRole(roles)) {
                String msg = "Insufficient permissions, runAsPrincipal=" + callerRunAsIdentity.getName() + ", requiredRoles=" + roles + ", runAsRoles=" + callerRunAsIdentity.getRunAsRoles();
                this.log.error(msg);
                throw new SecurityException(msg);
            }
        }
        return invocation.invokeNext();
    }
}

