/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.AccessibleObject;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SecurityActions {
    SecurityActions() {
    }

    static void setAccessible(AccessibleObject accessibleObject) {
        if (System.getSecurityManager() == null) {
            SetAccessibleAction.NON_PRIVILEGED.setAccessible(accessibleObject);
        } else {
            SetAccessibleAction.PRIVILEGED.setAccessible(accessibleObject);
        }
    }

    static interface SetAccessibleAction {
        public static final SetAccessibleAction PRIVILEGED = new SetAccessibleAction(){

            public void setAccessible(final AccessibleObject accessibleObject) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            accessibleObject.setAccessible(true);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Error setting " + accessibleObject + " as accessible ", e.getException());
                }
            }
        };
        public static final SetAccessibleAction NON_PRIVILEGED = new SetAccessibleAction(){

            public void setAccessible(AccessibleObject accessibleObject) {
                accessibleObject.setAccessible(true);
            }
        };

        public void setAccessible(AccessibleObject var1);
    }
}

