/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.CodeConversionObserver;
import org.jboss.aop.instrument.Codifier;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.instrument.WrapperTransformer;
import org.jboss.aop.util.Advisable;

public abstract class FieldAccessTransformer
implements CodeConversionObserver {
    static final String FIELD_INFO_CLASS_NAME = "org.jboss.aop.FieldInfo";
    Instrumentor instrumentor;
    boolean optimize;
    private Codifier codifier;
    private JoinpointClassifier classifier;
    protected static final String[] transformations = new String[]{"get", "set"};
    protected static final int GET_INDEX = 0;
    protected static final int SET_INDEX = 1;
    protected static final WrapperTransformer wrapper = new WrapperTransformer(transformations);

    protected FieldAccessTransformer(Instrumentor instrumentor) {
        this.instrumentor = instrumentor;
        this.optimize = AspectManager.optimize;
        this.codifier = new Codifier();
        this.classifier = instrumentor.joinpointClassifier;
    }

    protected void buildFieldWrappers(CtClass clazz, ClassAdvisor advisor) throws NotFoundException, CannotCompileException {
        List fields = Instrumentor.getAdvisableFields(clazz);
        int fieldIndex = this.fieldOffset(clazz.getSuperclass());
        JoinpointClassification[] classificationGet = this.classifyFieldGet(clazz, advisor);
        JoinpointClassification[] classificationSet = this.classifyFieldSet(clazz, advisor);
        Iterator it = fields.iterator();
        boolean skipFieldInterception = true;
        int index = 0;
        while (it.hasNext()) {
            CtField field = (CtField)it.next();
            if (this.isPrepared(classificationGet[index]) || this.isPrepared(classificationSet[index])) {
                if (!Modifier.isPrivate((int)field.getModifiers())) {
                    skipFieldInterception = false;
                }
                this.doBuildFieldWrappers(clazz, field, fieldIndex, classificationGet[index], classificationSet[index]);
            }
            ++index;
            ++fieldIndex;
        }
        if (skipFieldInterception) {
            advisor.getManager().skipFieldAccess(clazz.getName());
        } else {
            advisor.getManager().addFieldInterceptionMarker(clazz.getName());
        }
    }

    protected boolean isPrepared(JoinpointClassification classification) {
        return classification != JoinpointClassification.NOT_INSTRUMENTED;
    }

    protected abstract void doBuildFieldWrappers(CtClass var1, CtField var2, int var3, JoinpointClassification var4, JoinpointClassification var5) throws NotFoundException, CannotCompileException;

    public boolean replaceFieldAccess(List fields, CtClass clazz, ClassAdvisor fieldsAdvisor) throws NotFoundException {
        CodeConverter converter = this.instrumentor.getCodeConverter();
        boolean converted = false;
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            JoinpointClassification fieldSetClassification;
            CtField field = (CtField)it.next();
            if (Modifier.isPrivate((int)field.getModifiers()) || !Advisable.isAdvisable(field)) continue;
            JoinpointClassification fieldGetClassification = this.classifier.classifyFieldGet(field, fieldsAdvisor);
            if (fieldGetClassification.equals(JoinpointClassification.WRAPPED)) {
                converted = true;
                converter.replaceFieldRead(field, clazz, FieldAccessTransformer.fieldRead(field.getName()));
            }
            if (!(fieldSetClassification = this.classifier.classifyFieldSet(field, fieldsAdvisor)).equals(JoinpointClassification.WRAPPED)) continue;
            converted = true;
            converter.replaceFieldWrite(field, clazz, FieldAccessTransformer.fieldWrite(field.getName()));
        }
        return converted;
    }

    public void wrap(CtClass clazz, Collection fieldsGet, Collection fieldsSet) throws CannotCompileException, NotFoundException {
        CtMethod method;
        String code;
        CtField field;
        int fieldIndex;
        List advisableFields = Instrumentor.getAdvisableFields(clazz);
        CtField[] fields = new CtField[advisableFields.size()];
        fields = advisableFields.toArray(fields);
        Iterator iterator = fieldsGet.iterator();
        while (iterator.hasNext()) {
            fieldIndex = (Integer)iterator.next();
            field = fields[fieldIndex];
            if (wrapper.isNotPrepared((CtMember)field, 0)) continue;
            wrapper.wrap((CtMember)field, 0);
            code = "{" + field.getType().getName() + " var; return var;}";
            method = this.getWrapperReadMethod(field, clazz);
            method.setBody(code);
            code = this.getWrapperBody(clazz, field, true, fieldIndex);
            if (!Modifier.isPrivate((int)field.getModifiers())) {
                this.instrumentor.converter.replaceFieldRead(field, clazz, FieldAccessTransformer.fieldRead(field.getName()));
                this.codifier.addPendingCode(method, code);
                continue;
            }
            this.replaceFieldAccessInternally(clazz, field, true, false, fieldIndex);
            method.setBody(code);
        }
        iterator = fieldsSet.iterator();
        while (iterator.hasNext()) {
            fieldIndex = (Integer)iterator.next();
            field = fields[fieldIndex];
            if (wrapper.isNotPrepared((CtMember)field, 1)) continue;
            wrapper.wrap((CtMember)field, 1);
            code = "{  }";
            method = this.getWrapperWriteMethod(field, clazz);
            method.setBody(code);
            code = this.getWrapperBody(clazz, field, false, fieldIndex);
            if (!Modifier.isPrivate((int)field.getModifiers())) {
                this.instrumentor.converter.replaceFieldWrite(field, clazz, FieldAccessTransformer.fieldWrite(field.getName()));
                this.codifier.addPendingCode(method, code);
                continue;
            }
            this.replaceFieldAccessInternally(clazz, field, false, true, fieldIndex);
            method.setBody(code);
        }
    }

    protected CtMethod getWrapperReadMethod(CtField field, CtClass clazz) throws NotFoundException {
        return clazz.getDeclaredMethod(FieldAccessTransformer.fieldRead(field.getName()));
    }

    protected CtMethod getWrapperWriteMethod(CtField field, CtClass clazz) throws NotFoundException {
        return clazz.getDeclaredMethod(FieldAccessTransformer.fieldWrite(field.getName()));
    }

    public void unwrap(CtClass clazz, Collection fieldsGet, Collection fieldsSet) throws CannotCompileException, NotFoundException {
        String target;
        CtMethod method;
        CtField field;
        int fieldIndex;
        ClassPool classPool = this.instrumentor.getClassPool();
        List advisableFields = Instrumentor.getAdvisableFields(clazz);
        CtField[] fields = new CtField[advisableFields.size()];
        fields = advisableFields.toArray(fields);
        Iterator iterator = fieldsGet.iterator();
        while (iterator.hasNext()) {
            fieldIndex = (Integer)iterator.next();
            field = fields[fieldIndex];
            if (wrapper.isNotPrepared((CtMember)field, 0)) continue;
            wrapper.unwrap((CtMember)field, 0);
            method = clazz.getDeclaredMethod(FieldAccessTransformer.fieldRead(field.getName()));
            target = Modifier.isStatic((int)field.getModifiers()) ? clazz.getName() : "((" + clazz.getName() + ")$1)";
            method.setBody("return " + target + "." + field.getName() + ";");
        }
        iterator = fieldsSet.iterator();
        while (iterator.hasNext()) {
            fieldIndex = (Integer)iterator.next();
            field = fields[fieldIndex];
            if (wrapper.isNotPrepared((CtMember)field, 1)) continue;
            wrapper.unwrap((CtMember)field, 1);
            method = clazz.getDeclaredMethod(FieldAccessTransformer.fieldWrite(field.getName()));
            target = Modifier.isStatic((int)field.getModifiers()) ? clazz.getName() : "((" + clazz.getName() + ")$1)";
            method.setBody(target + "." + field.getName() + "=$2" + ";");
        }
    }

    public void codeConverted() throws NotFoundException, CannotCompileException {
        this.codifier.codifyPending();
    }

    protected int fieldOffset(CtClass clazz) throws NotFoundException {
        if (clazz == null) {
            return 0;
        }
        if (clazz.getName().equals("java.lang.Object")) {
            return 0;
        }
        int offset = this.fieldOffset(clazz.getSuperclass());
        CtField[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Advisable.isAdvisable(fields[i])) continue;
            ++offset;
        }
        return offset;
    }

    private JoinpointClassification[] classifyFieldGet(CtClass clazz, ClassAdvisor advisor) throws NotFoundException {
        List fields = Instrumentor.getAdvisableFields(clazz);
        JoinpointClassification[] classification = new JoinpointClassification[fields.size()];
        int index = 0;
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            CtField field = (CtField)iterator.next();
            classification[index] = this.instrumentor.joinpointClassifier.classifyFieldGet(field, advisor);
            ++index;
        }
        return classification;
    }

    private JoinpointClassification[] classifyFieldSet(CtClass clazz, ClassAdvisor advisor) throws NotFoundException {
        List fields = Instrumentor.getAdvisableFields(clazz);
        JoinpointClassification[] classification = new JoinpointClassification[fields.size()];
        int index = 0;
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            CtField field = (CtField)iterator.next();
            classification[index] = this.instrumentor.joinpointClassifier.classifyFieldSet(field, advisor);
            ++index;
        }
        return classification;
    }

    protected String addFieldReadInfoFieldWithAccessors(int modifiers, CtClass addTo, CtField field) throws NotFoundException, CannotCompileException {
        return this.addFieldReadInfoFieldWithAccessors(modifiers, addTo, field, null);
    }

    protected String addFieldReadInfoFieldWithAccessors(int modifiers, CtClass addTo, CtField field, CtField.Initializer init) throws NotFoundException, CannotCompileException {
        String name = FieldAccessTransformer.getFieldReadInfoFieldName(field.getName());
        TransformerCommon.addInfoField(this.instrumentor, FIELD_INFO_CLASS_NAME, name, modifiers, addTo, this.addInfoAsWeakReference(), init);
        return name;
    }

    protected String addFieldWriteInfoField(int modifiers, CtClass addTo, CtField field) throws NotFoundException, CannotCompileException {
        return this.addFieldWriteInfoField(modifiers, addTo, field, null);
    }

    protected String addFieldWriteInfoField(int modifiers, CtClass addTo, CtField field, CtField.Initializer init) throws NotFoundException, CannotCompileException {
        String name = FieldAccessTransformer.getFieldWriteInfoFieldName(field.getName());
        TransformerCommon.addInfoField(this.instrumentor, FIELD_INFO_CLASS_NAME, name, modifiers, addTo, this.addInfoAsWeakReference(), init);
        return name;
    }

    protected boolean addInfoAsWeakReference() {
        return true;
    }

    public static String getFieldReadInfoFieldName(String fieldName) {
        return "aop$FieldInfo_r_" + fieldName;
    }

    public static String getFieldWriteInfoFieldName(String fieldName) {
        return "aop$FieldInfo_w_" + fieldName;
    }

    public static String fieldRead(String fieldName) {
        return fieldName + "_r_" + "$aop";
    }

    public static String fieldWrite(String fieldName) {
        return fieldName + "_w_" + "$aop";
    }

    protected static String fieldInfoFromWeakReference(String localName, String fieldInfoName) {
        return TransformerCommon.infoFromWeakReference(FIELD_INFO_CLASS_NAME, localName, fieldInfoName);
    }

    protected int getStaticModifiers(CtField field) {
        int mod = 8;
        mod = (field.getModifiers() & 1) != 0 ? (mod |= 1) : ((field.getModifiers() & 4) != 0 ? (mod |= 4) : ((field.getModifiers() & 2) != 0 ? (mod |= 2) : (mod |= 1)));
        return mod;
    }

    protected abstract void replaceFieldAccessInternally(CtClass var1, CtField var2, boolean var3, boolean var4, int var5) throws CannotCompileException;

    protected void buildWrapperPlaceHolders(CtClass clazz, CtField field, boolean doGet, boolean doSet, int mod) throws NotFoundException, CannotCompileException {
        if (doGet) {
            this.buildReadWrapperPlaceHolder(clazz, field, FieldAccessTransformer.fieldRead(field.getName()), mod);
        }
        if (doSet) {
            this.buildWriteWrapperPlaceHolder(clazz, field, FieldAccessTransformer.fieldWrite(field.getName()), mod);
        }
    }

    protected CtMethod buildReadWrapperPlaceHolder(CtClass clazz, CtField field, String wrapperName, int mod) throws NotFoundException, CannotCompileException {
        AOPClassPool classPool = (AOPClassPool)this.instrumentor.getClassPool();
        String name = field.getName();
        CtClass ftype = field.getType();
        CtClass[] readParam = new CtClass[]{classPool.get("java.lang.Object")};
        String code = "{" + ftype.getName() + " var = ";
        if (ftype.isPrimitive()) {
            if (ftype == CtClass.booleanType) {
                code = code + false;
            } else if (ftype == CtClass.byteType) {
                code = code + "(byte)0";
            } else if (ftype == CtClass.charType) {
                code = code + "(char)0";
            } else if (ftype == CtClass.doubleType) {
                code = code + "0.0";
            } else if (ftype == CtClass.floatType) {
                code = code + "(float)0.0";
            } else if (ftype == CtClass.intType) {
                code = code + "0";
            } else if (ftype == CtClass.longType) {
                code = code + "(long)0";
            } else if (ftype == CtClass.shortType) {
                code = code + "(short)0";
            }
        } else {
            code = code + "null";
        }
        code = code + "; return var;}";
        CtMethod rmethod = CtNewMethod.make((CtClass)ftype, (String)wrapperName, (CtClass[])readParam, null, (String)code, (CtClass)clazz);
        rmethod.setModifiers(mod);
        clazz.addMethod(rmethod);
        return rmethod;
    }

    protected CtMethod buildWriteWrapperPlaceHolder(CtClass clazz, CtField field, String wrapperName, int mod) throws NotFoundException, CannotCompileException {
        AOPClassPool classPool = (AOPClassPool)this.instrumentor.getClassPool();
        String name = field.getName();
        CtClass ftype = field.getType();
        CtClass[] writeParam = new CtClass[]{classPool.get("java.lang.Object"), ftype};
        CtMethod wmethod = CtNewMethod.make((CtClass)CtClass.voidType, (String)wrapperName, (CtClass[])writeParam, null, (String)"{}", (CtClass)clazz);
        wmethod.setModifiers(mod);
        clazz.addMethod(wmethod);
        return wmethod;
    }

    protected abstract String getWrapperBody(CtClass var1, CtField var2, boolean var3, int var4) throws NotFoundException, CannotCompileException;

    protected abstract class FieldAccessExprEditor
    extends ExprEditor {
        CtClass clazz;
        CtField field;
        boolean doGet;
        boolean doSet;
        int fieldIndex;

        public FieldAccessExprEditor(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) {
            this.clazz = clazz;
            this.field = field;
            this.doGet = doGet;
            this.doSet = doSet;
            this.fieldIndex = index;
        }

        public void edit(FieldAccess fieldAccess) throws CannotCompileException {
            if (!fieldAccess.getClassName().equals(this.clazz.getName())) {
                return;
            }
            if (!fieldAccess.getFieldName().equals(this.field.getName())) {
                return;
            }
            if (this.calledByInvocationClass(fieldAccess)) {
                return;
            }
            if (fieldAccess.isReader() && this.doGet) {
                this.replaceRead(fieldAccess);
            }
            if (fieldAccess.isWriter() && this.doSet) {
                this.replaceWrite(fieldAccess);
            }
        }

        private boolean calledByInvocationClass(FieldAccess fieldAccess) {
            try {
                return this.isInvocationClass(fieldAccess.where().getDeclaringClass());
            }
            catch (RuntimeException e) {
                return true;
            }
        }

        private boolean isInvocationClass(CtClass superClazz) {
            try {
                if (superClazz == null) {
                    return false;
                }
                if (superClazz.getName().equals("java.lang.Object")) {
                    return false;
                }
                if (superClazz.getName().equals("org.jboss.aop.joinpoint.Invocation")) {
                    return true;
                }
                return this.isInvocationClass(superClazz.getSuperclass());
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        protected abstract void replaceRead(FieldAccess var1) throws CannotCompileException;

        protected abstract void replaceWrite(FieldAccess var1) throws CannotCompileException;
    }
}

