/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.Loader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;

public class CustomLoader
extends Loader {
    private final Type[] resultTypes;
    private final Loadable[] persisters;
    private final CollectionPersister[] collectionPersisters;
    private final CustomQuery customQuery;
    private Type[] discoveredTypes;
    private String[] discoveredColumnAliases;
    private ResultSetMetaData metaData;
    private final String[] queryReturnAliases;

    public CustomLoader(CustomQuery customQuery, SessionFactoryImplementor factory) {
        super(factory);
        int i;
        this.customQuery = customQuery;
        this.queryReturnAliases = customQuery.getReturnAliases();
        String[] collectionRoles = customQuery.getCollectionRoles();
        if (collectionRoles == null) {
            this.collectionPersisters = null;
        } else {
            int length = collectionRoles.length;
            this.collectionPersisters = new CollectionPersister[length];
            for (i = 0; i < length; ++i) {
                this.collectionPersisters[i] = factory.getCollectionPersister(collectionRoles[i]);
            }
        }
        String[] entityNames = customQuery.getEntityNames();
        this.persisters = new Loadable[entityNames.length];
        for (i = 0; i < entityNames.length; ++i) {
            this.persisters[i] = (Loadable)factory.getEntityPersister(entityNames[i]);
        }
        Type[] scalarTypes = customQuery.getScalarTypes();
        this.resultTypes = new Type[entityNames.length + (scalarTypes == null ? 0 : scalarTypes.length)];
        System.arraycopy(scalarTypes, 0, this.resultTypes, 0, scalarTypes.length);
        for (int i2 = 0; i2 < entityNames.length; ++i2) {
            this.resultTypes[i2 + scalarTypes.length] = TypeFactory.manyToOne(entityNames[i2]);
        }
    }

    protected String getSQLString() {
        return this.customQuery.getSQL();
    }

    protected Loadable[] getEntityPersisters() {
        return this.persisters;
    }

    protected LockMode[] getLockModes(Map lockModesMap) {
        return this.customQuery.getLockModes();
    }

    protected CollectionPersister[] getCollectionPersisters() {
        return this.collectionPersisters;
    }

    protected int[] getCollectionOwners() {
        return this.customQuery.getCollectionOwner();
    }

    protected int[] getOwners() {
        return this.customQuery.getEntityOwners();
    }

    public Set getQuerySpaces() {
        return this.customQuery.getQuerySpaces();
    }

    protected String getQueryIdentifier() {
        return this.customQuery.getSQL();
    }

    public List list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        return this.list(session, queryParameters, this.customQuery.getQuerySpaces(), this.resultTypes);
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        return this.scroll(queryParameters, this.resultTypes, CustomLoader.getHolderInstantiator(queryParameters.getResultTransformer(), this.getReturnAliasesForTransformer()), session);
    }

    private static HolderInstantiator getHolderInstantiator(ResultTransformer resultTransformer, String[] queryReturnAliases) {
        if (resultTransformer != null) {
            return HolderInstantiator.NOOP_INSTANTIATOR;
        }
        return new HolderInstantiator(resultTransformer, queryReturnAliases);
    }

    protected void autoDiscoverTypes(ResultSet rs) {
        try {
            this.metaData = rs.getMetaData();
            Type[] scalarTypes = this.customQuery.getScalarTypes();
            if (scalarTypes.length == 0) {
                int columnCount = this.metaData.getColumnCount();
                this.discoveredTypes = new Type[columnCount];
                this.discoveredColumnAliases = new String[columnCount];
                for (int i = 1; i <= columnCount; ++i) {
                    this.discoveredTypes[i - 1] = this.getHibernateType(i);
                    this.discoveredColumnAliases[i - 1] = this.metaData.getColumnName(i);
                }
            } else {
                String[] scalarColumnAliases = this.customQuery.getScalarColumnAliases();
                this.discoveredTypes = new Type[scalarTypes.length];
                this.discoveredColumnAliases = new String[scalarTypes.length];
                for (int i = 0; i < scalarTypes.length; ++i) {
                    this.discoveredColumnAliases[i] = scalarColumnAliases[i];
                    if (scalarTypes[i] == null) {
                        String alias = scalarColumnAliases[i];
                        int column = rs.findColumn(alias);
                        this.discoveredTypes[i] = this.getHibernateType(column);
                        continue;
                    }
                    this.discoveredTypes[i] = scalarTypes[i];
                }
            }
        }
        catch (SQLException e) {
            throw new HibernateException("Exception while trying to autodiscover types.", e);
        }
    }

    private Type getHibernateType(int columnPos) throws SQLException {
        int columnType = this.metaData.getColumnType(columnPos);
        int scale = this.metaData.getScale(columnPos);
        int precision = this.metaData.getPrecision(columnPos);
        return TypeFactory.heuristicType(this.getFactory().getDialect().getHibernateTypeName(columnType, precision, precision, scale));
    }

    protected Object getResultColumnOrRow(Object[] row, ResultTransformer transformer, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        Object[] resultRow;
        String[] scalarColumnAliases;
        Type[] scalarTypes = this.discoveredTypes == null ? this.customQuery.getScalarTypes() : this.discoveredTypes;
        String[] stringArray = scalarColumnAliases = this.discoveredColumnAliases == null ? this.customQuery.getScalarColumnAliases() : this.discoveredColumnAliases;
        if (scalarTypes != null && scalarTypes.length > 0) {
            resultRow = new Object[scalarTypes.length + row.length];
            for (int i = 0; i < scalarTypes.length; ++i) {
                resultRow[i] = scalarTypes[i].nullSafeGet(rs, scalarColumnAliases[i], session, null);
            }
            System.arraycopy(row, 0, resultRow, scalarTypes.length, row.length);
        } else {
            resultRow = row;
        }
        if (transformer != null) {
            return resultRow;
        }
        return resultRow.length == 1 ? resultRow[0] : resultRow;
    }

    protected List getResultList(List results, ResultTransformer resultTransformer) throws QueryException {
        HolderInstantiator holderInstantiator = HolderInstantiator.getHolderInstantiator(null, resultTransformer, this.getReturnAliasesForTransformer());
        if (holderInstantiator.isRequired()) {
            for (int i = 0; i < results.size(); ++i) {
                Object[] row = (Object[])results.get(i);
                Object result = holderInstantiator.instantiate(row);
                results.set(i, result);
            }
            return resultTransformer.transformList(results);
        }
        return results;
    }

    private String[] getReturnAliasesForTransformer() {
        if (this.discoveredColumnAliases != null) {
            return this.discoveredColumnAliases;
        }
        return this.queryReturnAliases;
    }

    protected EntityAliases[] getEntityAliases() {
        return this.customQuery.getEntityAliases();
    }

    protected CollectionAliases[] getCollectionAliases() {
        return this.customQuery.getCollectionAliases();
    }

    public int[] getNamedParameterLocs(String name) throws QueryException {
        Object loc = this.customQuery.getNamedParameterBindPoints().get(name);
        if (loc == null) {
            throw new QueryException("Named parameter does not appear in Query: " + name, this.customQuery.getSQL());
        }
        if (loc instanceof Integer) {
            return new int[]{(Integer)loc};
        }
        return ArrayHelper.toIntArray((List)loc);
    }
}

