/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.util.stream.Streams;

public final class Files {
    private static final Logger log = Logger.getLogger((Class)Files.class);
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public static boolean delete(File file) {
        boolean bl = true;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    if (Files.delete(file2)) continue;
                    bl = false;
                    log.debug((Object)("Failed to delete dir: " + file2.getAbsolutePath()));
                    continue;
                }
                if (file2.delete()) continue;
                bl = false;
                log.debug((Object)("Failed to delete file: " + file2.getAbsolutePath()));
            }
        }
        if (!file.delete()) {
            bl = false;
            log.debug((Object)("Failed to delete dir: " + file.getAbsolutePath()));
        }
        return bl;
    }

    public static boolean delete(String string) {
        return Files.delete(new File(string));
    }

    public static boolean deleteContaining(String string) {
        File file = new File(string);
        File file2 = file.getParentFile();
        return Files.delete(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2, byte[] byArray) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        try {
            int n;
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            Streams.flush((OutputStream)bufferedOutputStream);
            Streams.close((InputStream)bufferedInputStream);
            Streams.close((OutputStream)bufferedOutputStream);
        }
    }

    public static void copy(File file, File file2, int n) throws IOException {
        Files.copy(file, file2, new byte[n]);
    }

    public static void copy(File file, File file2) throws IOException {
        Files.copy(file, file2, 8192);
    }

    public static void copy(URL uRL, File file) throws IOException {
        log.debug((Object)("Copying " + uRL + " -> " + file));
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("mkdirs failed for: " + file2.getAbsolutePath());
        }
        if (file.exists() && !Files.delete(file)) {
            throw new IOException("delete of previous content failed for: " + file.getAbsolutePath());
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        Streams.copy((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
        ((InputStream)bufferedInputStream).close();
    }

    public static String encodeFileName(String string) {
        return Files.encodeFileName(string, '@');
    }

    public static String decodeFileName(String string) {
        return Files.decodeFileName(string, '@');
    }

    public static String encodeFileName(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    stringBuffer.append(string.charAt(i));
                    continue block5;
                }
                default: {
                    try {
                        byte[] byArray = ("" + string.charAt(i)).getBytes("UTF8");
                        for (int j = 0; j < byArray.length; ++j) {
                            stringBuffer.append(c);
                            stringBuffer.append(hexDigits[byArray[j] >> 4 & 0xF]);
                            stringBuffer.append(hexDigits[byArray[j] & 0xF]);
                        }
                        continue block5;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String decodeFileName(String string, char c) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                int n;
                char c3 = string.charAt(++i);
                char c4 = string.charAt(++i);
                int n2 = c3 >= 'a' ? 10 + c3 - 97 : (n = c3 >= 'A' ? 10 + c3 - 65 : c3 - 48);
                int n3 = c4 >= 'a' ? 10 + c4 - 97 : (c4 >= 'A' ? 10 + c4 - 65 : c4 - 48);
                byte[] byArray = new byte[]{(byte)(n * 16 + n3)};
                try {
                    String string2 = new String(byArray, "UTF8");
                    stringBuffer.append(string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String findRelativePath(String string, String string2) throws IOException {
        int n;
        int n2;
        String string3 = new File(string).getCanonicalFile().toURI().getPath();
        String string4 = new File(string2).getCanonicalFile().toURI().getPath();
        String[] stringArray = string3.split("/");
        String[] stringArray2 = string4.split("/");
        for (n2 = 0; n2 < stringArray.length && n2 < stringArray2.length && stringArray[n2].equals(stringArray2[n2]); ++n2) {
        }
        System.out.println("Common length: " + n2);
        StringBuffer stringBuffer = new StringBuffer("../");
        for (n = n2; n < stringArray.length - 1; ++n) {
            stringBuffer.append("../");
        }
        for (n = n2; n < stringArray2.length; ++n) {
            stringBuffer.append(stringArray2[n]);
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }
}

