/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import org.hibernate.cfg.reveng.TableIdentifier;

public class TableFilter {
    private Boolean exclude;
    private String packageName;
    private Matcher catalogMatcher;
    private Matcher schemaMatcher;
    private Matcher nameMatcher;

    public TableFilter() {
        this.setMatchCatalog(".*");
        this.setMatchSchema(".*");
        this.setMatchName(".*");
        this.setExclude(null);
    }

    public void setMatchCatalog(String matchCatalog) {
        this.catalogMatcher = new Matcher(matchCatalog);
    }

    public void setMatchSchema(String matchSchema) {
        this.schemaMatcher = new Matcher(matchSchema);
    }

    public void setMatchName(String matchName) {
        this.nameMatcher = new Matcher(matchName);
    }

    public Boolean exclude(TableIdentifier identifier) {
        return this.isRelevantFor(identifier) ? this.exclude : null;
    }

    public void setExclude(Boolean bool) {
        this.exclude = bool;
    }

    public String getPackage(TableIdentifier identifier) {
        return this.isRelevantFor(identifier) ? this.packageName : null;
    }

    private boolean isRelevantFor(TableIdentifier identifier) {
        return this.catalogMatcher.match(identifier.getCatalog()) && this.schemaMatcher.match(identifier.getSchema()) && this.nameMatcher.match(identifier.getName());
    }

    public void setPackage(String string) {
        this.packageName = string;
    }

    public String toString() {
        return this.catalogMatcher + " " + this.schemaMatcher + " " + this.nameMatcher + " " + this.exclude;
    }

    public String getMatchCatalog() {
        return this.catalogMatcher.matchValue;
    }

    public String getMatchSchema() {
        return this.schemaMatcher.matchValue;
    }

    public String getMatchName() {
        return this.nameMatcher.matchValue;
    }

    public Boolean getExclude() {
        return this.exclude;
    }

    public static class Matcher {
        private static final int EQUALS = 1;
        private static final int ENDSWITH = 2;
        private static final int STARTSWITH = 3;
        private static final int SUBSTRING = 4;
        private static final int ANY = 5;
        final int mode;
        final String value;
        final String matchValue;

        Matcher(String match) {
            this.matchValue = match;
            if (".*".equals(match)) {
                this.mode = 5;
                this.value = null;
            } else if (match.length() > 4 && match.startsWith(".*") && match.endsWith(".*")) {
                this.mode = 4;
                this.value = match.substring(2, match.length() - 2);
            } else if (match.endsWith(".*")) {
                this.mode = 3;
                this.value = match.substring(0, match.length() - 2);
            } else if (match.startsWith(".*")) {
                this.mode = 2;
                this.value = match.substring(2);
            } else {
                this.mode = 1;
                this.value = match;
            }
        }

        boolean match(String value) {
            switch (this.mode) {
                case 5: {
                    return true;
                }
                case 1: {
                    return this.value.equals(value);
                }
                case 2: {
                    return value.endsWith(this.value);
                }
                case 3: {
                    return value.startsWith(this.value);
                }
                case 4: {
                    return value.indexOf(this.value) >= 0;
                }
            }
            throw new IllegalStateException();
        }

        public String toString() {
            return this.matchValue;
        }
    }
}

