/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbmlint;

import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.tool.hbm2x.visitor.EntityNameFromValueVisitor;
import org.hibernate.tool.hbmlint.Analyzer;
import org.hibernate.tool.hbmlint.AnalyzerProblem;

public class CacheAnalyzer
extends Analyzer {
    public AnalyzerProblem analyze(Configuration cfg, Property property) {
        PersistentClass classMapping;
        String entityName;
        Collection col;
        Value value = property.getValue();
        if (value instanceof Collection && (col = (Collection)value).getCacheConcurrencyStrategy() != null && !col.getElement().isSimpleValue() && (entityName = (String)col.getElement().accept((ValueVisitor)new EntityNameFromValueVisitor())) != null && (classMapping = cfg.getClassMapping(entityName)).getCacheConcurrencyStrategy() == null) {
            return new AnalyzerProblem("Entity '" + classMapping.getEntityName() + "' is referenced from the cache-enabled collection '" + col.getRole() + "' without the entity being cachable");
        }
        return super.analyze(cfg, property);
    }
}

