/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbmlint;

import org.hibernate.MappingException;
import org.hibernate.bytecode.cglib.BytecodeProviderImpl;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.Settings;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.hbmlint.Analyzer;
import org.hibernate.tool.hbmlint.AnalyzerProblem;

public class BytecodeAnalyzer
extends Analyzer {
    private boolean cglibEnabled;
    private boolean javassistEnabled;

    public void initialize(Configuration cfg, Settings settings) {
        super.initialize(cfg, settings);
        this.cglibEnabled = false;
        this.javassistEnabled = false;
        if (Environment.getBytecodeProvider() instanceof BytecodeProviderImpl) {
            this.cglibEnabled = true;
        } else if (Environment.getBytecodeProvider() instanceof BytecodeProviderImpl) {
            this.javassistEnabled = true;
        }
    }

    public AnalyzerProblem analyze(Configuration cfg, PersistentClass clazz) {
        Class mappedClass;
        try {
            mappedClass = clazz.getMappedClass();
        }
        catch (MappingException me) {
            return null;
        }
        if (clazz.isLazy()) {
            try {
                mappedClass.getConstructor(new Class[0]);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                return new AnalyzerProblem("lazy='true' set for '" + clazz.getEntityName() + "', but class has no default constructor");
            }
        } else if (this.cglibEnabled || this.javassistEnabled) {
            Class<?>[] interfaces = mappedClass.getInterfaces();
            boolean cglib = false;
            boolean javaassist = false;
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> intface = interfaces[i];
                if (intface.getName().equals("net.sf.cglib.transform.impl.InterceptFieldEnabled")) {
                    cglib = true;
                    continue;
                }
                if (!this.javassistEnabled || intface.getName().equals("org.hibernate.bytecode.javassist.FieldHandled")) continue;
                javaassist = true;
            }
            if (this.cglibEnabled && !cglib) {
                return new AnalyzerProblem("'" + clazz.getEntityName() + "' has lazy='false', but its class '" + mappedClass.getName() + "' has not been instrumented with cglib");
            }
            if (this.javassistEnabled && !javaassist) {
                return new AnalyzerProblem("'" + clazz.getEntityName() + "' has lazy='false', but its class '" + mappedClass.getName() + "' has not been instrumented with javaassist");
            }
        }
        return super.analyze(cfg, clazz);
    }
}

