/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.utils.DBConnectionManager;

public class JobStoreCMT
extends JobStoreSupport {
    protected String nonManagedTxDsName;
    protected boolean dontSetNonManagedTXConnectionAutoCommitFalse = false;
    protected boolean setTxIsolationLevelReadCommitted = false;

    public void setNonManagedTXDataSource(String nonManagedTxDsName) {
        this.nonManagedTxDsName = nonManagedTxDsName;
    }

    public String getNonManagedTXDataSource() {
        return this.nonManagedTxDsName;
    }

    public boolean isDontSetNonManagedTXConnectionAutoCommitFalse() {
        return this.dontSetNonManagedTXConnectionAutoCommitFalse;
    }

    public void setDontSetNonManagedTXConnectionAutoCommitFalse(boolean b) {
        this.dontSetNonManagedTXConnectionAutoCommitFalse = b;
    }

    public boolean isTxIsolationLevelReadCommitted() {
        return this.setTxIsolationLevelReadCommitted;
    }

    public void setTxIsolationLevelReadCommitted(boolean b) {
        this.setTxIsolationLevelReadCommitted = b;
    }

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        if (this.nonManagedTxDsName == null) {
            throw new SchedulerConfigException("Non-ManagedTX DataSource name not set!");
        }
        this.setUseDBLocks(true);
        super.initialize(loadHelper, signaler);
        this.getLog().info("JobStoreCMT initialized.");
    }

    public void shutdown() {
        super.shutdown();
        try {
            DBConnectionManager.getInstance().shutdown(this.getNonManagedTXDataSource());
        }
        catch (SQLException sqle) {
            this.getLog().warn("Database connection shutdown unsuccessful.", sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void recoverJobs() throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        conn = this.getNonManagedTXConnection();
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.recoverJobs(conn);
        conn.commit();
        Object var5_3 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            catch (Exception e) {
                this.rollbackConnection(conn);
                throw new JobPersistenceException("Error recovering jobs: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void cleanVolatileTriggerAndJobs() throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        conn = this.getNonManagedTXConnection();
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.cleanVolatileTriggerAndJobs(conn);
        conn.commit();
        Object var5_3 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            catch (Exception e) {
                this.rollbackConnection(conn);
                throw new JobPersistenceException("Error cleaning volatile data: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJobAndTrigger(SchedulingContext ctxt, JobDetail newJob, Trigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            if (this.isLockOnInsert()) {
                this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
                transOwner = true;
            }
            if (newJob.isVolatile() && !newTrigger.isVolatile()) {
                JobPersistenceException jpe = new JobPersistenceException("Cannot associate non-volatile trigger with a volatile job!");
                jpe.setErrorCode(100);
                throw jpe;
            }
            this.storeJob(conn, ctxt, newJob, false);
            this.storeTrigger(conn, ctxt, newTrigger, newJob, false, "WAITING", false, false);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJob(SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            if (this.isLockOnInsert() || replaceExisting) {
                this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
                transOwner = true;
            }
            this.storeJob(conn, ctxt, newJob, replaceExisting);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        boolean bl;
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            bl = this.removeJob(conn, ctxt, jobName, groupName, true);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobDetail retrieveJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            JobDetail jobDetail = this.retrieveJob(conn, ctxt, jobName, groupName);
            return jobDetail;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTrigger(SchedulingContext ctxt, Trigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            if (this.isLockOnInsert() || replaceExisting) {
                this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
                transOwner = true;
            }
            this.storeTrigger(conn, ctxt, newTrigger, null, replaceExisting, "WAITING", false, false);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        boolean bl;
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            bl = this.removeTrigger(conn, ctxt, triggerName, groupName);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceTrigger(SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger) throws JobPersistenceException {
        boolean bl;
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            bl = this.replaceTrigger(conn, ctxt, triggerName, groupName, newTrigger);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger retrieveTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            Trigger trigger = this.retrieveTrigger(conn, ctxt, triggerName, groupName);
            return trigger;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCalendar(SchedulingContext ctxt, String calName, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean lockOwner = false;
        try {
            if (this.isLockOnInsert() || updateTriggers) {
                this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
                lockOwner = true;
            }
            this.storeCalendar(conn, ctxt, calName, calendar, replaceExisting, updateTriggers);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, lockOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, lockOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        boolean bl;
        Connection conn = this.getConnection();
        boolean lockOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_CALENDAR_ACCESS);
            lockOwner = true;
            bl = this.removeCalendar(conn, ctxt, calName);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, lockOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, lockOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar retrieveCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            Calendar calendar = this.retrieveCalendar(conn, ctxt, calName);
            return calendar;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfJobs(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int n = this.getNumberOfJobs(conn, ctxt);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfTriggers(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int n = this.getNumberOfTriggers(conn, ctxt);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCalendars(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int n = this.getNumberOfCalendars(conn, ctxt);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPausedTriggerGroups(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            Set groups;
            Set set = groups = this.getPausedTriggerGroups(conn, ctxt);
            return set;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getJobNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] stringArray = this.getJobNames(conn, ctxt, groupName);
            return stringArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTriggerNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] stringArray = this.getTriggerNames(conn, ctxt, groupName);
            return stringArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getJobGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] stringArray = this.getJobGroupNames(conn, ctxt);
            return stringArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTriggerGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] stringArray = this.getTriggerGroupNames(conn, ctxt);
            return stringArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCalendarNames(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] stringArray = this.getCalendarNames(conn, ctxt);
            return stringArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger[] getTriggersForJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            Trigger[] triggerArray = this.getTriggersForJob(conn, ctxt, jobName, groupName);
            return triggerArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTriggerState(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int n = this.getTriggerState(conn, ctxt, triggerName, groupName);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.pauseTrigger(conn, ctxt, triggerName, groupName);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.pauseTriggerGroup(conn, ctxt, groupName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobName, groupName);
            for (int j = 0; j < triggers.length; ++j) {
                this.pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            String[] jobNames = this.getJobNames(conn, ctxt, groupName);
            for (int i = 0; i < jobNames.length; ++i) {
                Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobNames[i], groupName);
                for (int j = 0; j < triggers.length; ++j) {
                    this.pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.resumeTrigger(conn, ctxt, triggerName, groupName);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.resumeTriggerGroup(conn, ctxt, groupName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobName, groupName);
            for (int j = 0; j < triggers.length; ++j) {
                this.resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            String[] jobNames = this.getJobNames(conn, ctxt, groupName);
            for (int i = 0; i < jobNames.length; ++i) {
                Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobNames[i], groupName);
                for (int j = 0; j < triggers.length; ++j) {
                    this.resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAll(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.pauseAll(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAll(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
            this.resumeAll(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Trigger acquireNextTrigger(SchedulingContext ctxt, long noLaterThan) throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        conn = this.getNonManagedTXConnection();
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        Trigger trigger = this.acquireNextTrigger(conn, ctxt, noLaterThan);
        conn.commit();
        Trigger trigger2 = trigger;
        Object var9_9 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            return trigger2;
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            catch (Exception e) {
                this.rollbackConnection(conn);
                throw new JobPersistenceException("Error acquiring next firable trigger: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void releaseAcquiredTrigger(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        conn = this.getNonManagedTXConnection();
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.releaseAcquiredTrigger(conn, ctxt, trigger);
        conn.commit();
        Object var7_5 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            catch (Exception e) {
                this.rollbackConnection(conn);
                throw new JobPersistenceException("Error releasing acquired trigger: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public TriggerFiredBundle triggerFired(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        conn = this.getNonManagedTXConnection();
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        TriggerFiredBundle tfb = null;
        JobPersistenceException err = null;
        try {
            tfb = this.triggerFired(conn, ctxt, trigger);
        }
        catch (JobPersistenceException jpe) {
            if (jpe.getErrorCode() != 410) {
                throw jpe;
            }
            err = jpe;
        }
        if (err != null) {
            throw err;
        }
        conn.commit();
        TriggerFiredBundle triggerFiredBundle = tfb;
        Object var9_11 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            return triggerFiredBundle;
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            catch (Exception e) {
                this.rollbackConnection(conn);
                throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void triggeredJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode) throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        conn = this.getNonManagedTXConnection();
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.triggeredJobComplete(conn, ctxt, trigger, jobDetail, triggerInstCode);
        conn.commit();
        Object var9_7 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            catch (Exception e) {
                this.rollbackConnection(conn);
                throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected boolean doRecoverMisfires() throws JobPersistenceException {
        Connection conn = null;
        boolean transOwner = false;
        boolean moreToDo = false;
        conn = this.getNonManagedTXConnection();
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        try {
            moreToDo = this.recoverMisfiredJobs(conn, false);
        }
        catch (Exception e) {
            throw new JobPersistenceException(e.getMessage(), e);
        }
        conn.commit();
        boolean e = moreToDo;
        Object var6_8 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            return e;
            catch (JobPersistenceException e2) {
                this.rollbackConnection(conn);
                throw e2;
            }
            catch (Exception e3) {
                this.rollbackConnection(conn);
                throw new JobPersistenceException("TX failure: " + e3.getMessage(), e3);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean doCheckin() throws JobPersistenceException {
        List failedRecords;
        Connection conn = null;
        boolean transOwner = false;
        boolean transStateOwner = false;
        boolean recovered = false;
        conn = this.getNonManagedTXConnection();
        List list = failedRecords = this.firstCheckIn ? null : this.clusterCheckIn(conn);
        if (this.firstCheckIn || failedRecords.size() > 0) {
            this.getLockHandler().obtainLock(conn, LOCK_STATE_ACCESS);
            transStateOwner = true;
            List list2 = failedRecords = this.firstCheckIn ? this.clusterCheckIn(conn) : this.findFailedInstances(conn);
            if (failedRecords.size() > 0) {
                this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.clusterRecover(conn, failedRecords);
                recovered = true;
            }
        }
        conn.commit();
        Object var7_8 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                this.releaseLock(conn, LOCK_STATE_ACCESS, transStateOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_STATE_ACCESS, transStateOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            catch (Exception e) {
                this.rollbackConnection(conn);
                throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                Object var9_12 = null;
            }
            catch (Throwable throwable2) {
                Object var9_13 = null;
                try {
                    this.releaseLock(conn, LOCK_STATE_ACCESS, transStateOwner);
                }
                finally {
                    this.closeConnection(conn);
                }
                throw throwable2;
            }
            try {
                this.releaseLock(conn, LOCK_STATE_ACCESS, transStateOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        this.firstCheckIn = false;
        return recovered;
    }

    protected Connection getNonManagedTXConnection() throws JobPersistenceException {
        try {
            Connection conn = DBConnectionManager.getInstance().getConnection(this.getNonManagedTXDataSource());
            if (conn == null) {
                throw new SQLException("Could not get connection from DataSource '" + this.getNonManagedTXDataSource() + "'");
            }
            try {
                if (!this.isDontSetNonManagedTXConnectionAutoCommitFalse()) {
                    conn.setAutoCommit(false);
                }
                if (this.isTxIsolationLevelReadCommitted()) {
                    conn.setTransactionIsolation(1);
                }
            }
            catch (SQLException ingore) {
            }
            catch (Exception e) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw new JobPersistenceException("Failure setting up connection.", e);
            }
            return conn;
        }
        catch (SQLException sqle) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getNonManagedTXDataSource() + "': " + sqle.toString(), sqle);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getNonManagedTXDataSource() + "': " + e.toString(), e, 499);
        }
    }
}

