/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.introspection;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.introspection.ClassInfo;
import org.jboss.xb.util.NoopMap;

public class ClassInfos {
    private static Map classloaderCache = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableCache() {
        Map map = classloaderCache;
        synchronized (map) {
            classloaderCache = NoopMap.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableCache() {
        Map map = classloaderCache;
        synchronized (map) {
            if (!ClassInfos.isCacheEnabled()) {
                classloaderCache = new WeakHashMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCacheEnabled() {
        Map map = classloaderCache;
        synchronized (map) {
            return classloaderCache != NoopMap.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCache() {
        Map map = classloaderCache;
        synchronized (map) {
            classloaderCache.clear();
        }
    }

    public static void flushCache(String cls) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Map classLoaderCache = ClassInfos.getClassLoaderCache(cl);
        classLoaderCache.remove(cls);
    }

    public static void flushCache(Class cls) {
        Map classLoaderCache = ClassInfos.getClassLoaderCache(cls.getClassLoader());
        classLoaderCache.remove(cls.getName());
    }

    public static ClassInfo getClassInfo(Class cls) {
        Object result;
        Map classLoaderCache = ClassInfos.getClassLoaderCache(cls.getClassLoader());
        WeakReference<ClassInfo> weak = (WeakReference<ClassInfo>)classLoaderCache.get(cls.getName());
        if (weak != null && (result = weak.get()) != null) {
            return (ClassInfo)result;
        }
        ClassInfo clsInfo = new ClassInfo(cls);
        weak = new WeakReference<ClassInfo>(clsInfo);
        classLoaderCache.put(cls.getName(), weak);
        return clsInfo;
    }

    public static ClassInfo getClassInfo(String name, boolean required) {
        Object result;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Map classLoaderCache = ClassInfos.getClassLoaderCache(cl);
        WeakReference<ClassInfo> weak = (WeakReference<ClassInfo>)classLoaderCache.get(name);
        if (weak != null && (result = weak.get()) != null) {
            return (ClassInfo)result;
        }
        try {
            ClassInfo clsInfo = new ClassInfo(cl.loadClass(name));
            weak = new WeakReference<ClassInfo>(clsInfo);
            classLoaderCache.put(name, weak);
            return clsInfo;
        }
        catch (ClassNotFoundException e) {
            if (required) {
                throw new JBossXBRuntimeException("Failed to load class " + name);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getClassLoaderCache(ClassLoader cl) {
        Map map = classloaderCache;
        synchronized (map) {
            Map result = (Map)classloaderCache.get(cl);
            if (result == null) {
                result = new ConcurrentHashMap();
                classloaderCache.put(cl, result);
            }
            return result;
        }
    }
}

