/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.system.MissingAttributeException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigUtil;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.threadpool.BasicThreadPoolMBean;
import org.jboss.web.WebServer;
import org.jboss.web.WebServiceMBean;

public class WebService
extends ServiceMBeanSupport
implements WebServiceMBean {
    private WebServer server = new WebServer();

    public URL addClassLoader(ClassLoader cl) {
        return this.server.addClassLoader(cl);
    }

    public void removeClassLoader(ClassLoader cl) {
        this.server.removeClassLoader(cl);
    }

    public void setPort(int port) {
        this.server.setPort(port);
    }

    public int getPort() {
        return this.server.getPort();
    }

    public void setHost(String hostname) {
        this.server.setBindAddress(hostname);
    }

    public String getHost() {
        return this.server.getBindHostname();
    }

    public String getBindAddress() {
        return this.server.getBindAddress();
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.server.setBindAddress(host);
    }

    public int getBacklog() {
        return this.server.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.server.setBacklog(backlog);
    }

    public void setThreadPool(BasicThreadPoolMBean threadPool) {
        this.server.setThreadPool(threadPool);
    }

    public boolean getDownloadServerClasses() {
        return this.server.getDownloadServerClasses();
    }

    public void setDownloadServerClasses(boolean flag) {
        this.server.setDownloadServerClasses(flag);
    }

    public boolean getDownloadResources() {
        return this.server.getDownloadResources();
    }

    public void setDownloadResources(boolean flag) {
        this.server.setDownloadResources(flag);
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    protected void createService() throws Exception {
        String address;
        Properties mimeTypes = new Properties();
        try {
            mimeTypes.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jboss/web/mime.types"));
            Enumeration<Object> keys = mimeTypes.keys();
            while (keys.hasMoreElements()) {
                String extension = (String)keys.nextElement();
                String type = mimeTypes.getProperty(extension);
                this.server.addMimeType(extension, type);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to load org/jboss/web/mime.types; ignoring", e);
        }
        String hostname = this.server.getBindAddress();
        if (hostname == null) {
            try {
                hostname = System.getProperty("java.rmi.server.hostname");
            }
            catch (SecurityException e) {
                ThrowableHandler.addWarning(e);
            }
            if (hostname == null) {
                try {
                    hostname = InetAddress.getLocalHost().getHostName();
                }
                catch (IOException e) {
                    this.log.error("Failed to get localhost name; ignoring", e);
                }
            }
            if (hostname != null) {
                this.setHost(hostname);
            }
        }
        if ((address = this.getHost()) == null) {
            throw new MissingAttributeException("Host");
        }
        String codebase = System.getProperty("java.rmi.server.codebase");
        if (codebase == null) {
            address = ServerConfigUtil.fixRemoteAddress(address);
            codebase = "http://" + address + ":" + this.getPort() + "/";
            System.setProperty("java.rmi.server.codebase", codebase);
        }
        this.log.info("Using RMI server codebase: " + codebase);
    }

    protected void startService() throws Exception {
        this.server.start();
        this.log.debug("Started WebServer with address: " + this.server.getBindAddress() + ":" + this.getPort());
    }

    protected void stopService() throws Exception {
        this.server.stop();
    }
}

