/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.vfs.VFSFactory;
import org.jboss.vfs.VFSFactoryLocator;
import org.jboss.vfs.file.FileImpl;
import org.jboss.vfs.file.FileScanner;
import org.jboss.vfs.file.JarImpl;
import org.jboss.vfs.spi.ReadOnlyVFS;
import org.jboss.vfs.spi.VFSVisitor;
import org.jboss.vfs.spi.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemVFS
implements ReadOnlyVFS {
    private static Logger log = Logger.getLogger("org.jboss.vfs.file.FileSystemVFS");
    private static WeakHashMap<URL, FileSystemVFS> fileSystems = new WeakHashMap();
    private URL rootURL;
    private VirtualFile vfsRoot;
    private ConcurrentHashMap<String, VirtualFile> fileCache;

    public static VirtualFile getVirtualFile(String fileSystemPath) {
        try {
            File fp = new File(fileSystemPath);
            URL parent = fp.getParentFile().toURL();
            VFSFactory factory = VFSFactoryLocator.getFactory(parent);
            ReadOnlyVFS vfs = factory.getVFS(parent);
            return vfs.resolveFile(fp.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized FileSystemVFS getFileSystemVFS(URL rootURL) throws IOException {
        FileSystemVFS vfs = fileSystems.get(rootURL);
        if (vfs == null) {
            vfs = new FileSystemVFS(rootURL);
            fileSystems.put(rootURL, vfs);
        }
        return vfs;
    }

    FileSystemVFS(URL rootURL) throws IOException {
        this.rootURL = rootURL;
        String path = rootURL.getPath();
        this.vfsRoot = JarImpl.isJar(path) ? new JarImpl(path, "") : new FileImpl(rootURL, "", this);
        this.fileCache = new ConcurrentHashMap();
    }

    @Override
    public VirtualFile resolveFile(String path) throws FileNotFoundException, MalformedURLException {
        try {
            VirtualFile vf = this.resolveFile(path, "");
            return vf;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            FileNotFoundException fnfe = new FileNotFoundException(path);
            fnfe.initCause(e);
            throw fnfe;
        }
    }

    @Override
    public VirtualFile resolveFile(String path, List<String> searchContexts) throws IOException {
        VirtualFile match = null;
        for (String ctx : searchContexts) {
            match = this.fileCache.get(path);
            if (match == null) {
                match = this.resolveFile(path, ctx);
            }
            if (match == null) continue;
            break;
        }
        return match;
    }

    @Override
    public List<VirtualFile> resolveFiles(String path) {
        return null;
    }

    @Override
    public List<VirtualFile> resolveFiles(String path, List<URL> searchContexts) {
        return null;
    }

    @Override
    public void clear() {
        this.fileCache.clear();
    }

    @Override
    public Iterator<VirtualFile> scan(VFSVisitor acceptVisitor) {
        FileScanner scanner = new FileScanner(this.vfsRoot, acceptVisitor);
        return scanner;
    }

    @Override
    public URL getRootURL() {
        return this.rootURL;
    }

    private VirtualFile resolveFile(String path, String searchContext) throws IOException {
        VirtualFile match = null;
        String[] ctxAtoms = searchContext.split("!/|/");
        boolean inJar = false;
        StringBuffer vfsPath = new StringBuffer();
        VirtualFile prevVF = null;
        for (String atom : ctxAtoms) {
            if (vfsPath.length() > 0) {
                vfsPath.append('/');
            }
            vfsPath.append(atom);
            String atomPath = vfsPath.toString();
            String absPath = this.rootURL.getPath() + atomPath;
            VirtualFile atomVF = this.fileCache.get(atomPath);
            if (atomVF == null) {
                try {
                    if (inJar) {
                        atomVF = prevVF.findChild(atom);
                    } else if (JarImpl.isJar(atom)) {
                        atomVF = new JarImpl(absPath, atomPath);
                        inJar = true;
                    } else {
                        File atomFile = new File(absPath, atom);
                        atomVF = new FileImpl(atomFile, atomPath, this);
                    }
                    this.fileCache.put(atomPath, atomVF);
                    prevVF = atomVF;
                }
                catch (IOException e) {
                    log.log(Level.FINE, "Failed to create virtual file for atom up to: " + absPath, e);
                }
                continue;
            }
            prevVF = atomVF;
        }
        if (prevVF == null) {
            throw new FileNotFoundException("Failed to find file for path: " + path);
        }
        match = prevVF.findChild(path);
        return match;
    }

    VirtualFile getChild(URL parentURL, String path) throws IOException {
        String[] ctxAtoms = path.split("!/|/");
        boolean inJar = false;
        StringBuffer vfsPath = new StringBuffer();
        VirtualFile childVF = null;
        for (String atom : ctxAtoms) {
            if (vfsPath.length() > 0) {
                vfsPath.append('/');
            }
            vfsPath.append(atom);
            String atomPath = vfsPath.toString();
            String absPath = this.rootURL.getPath() + atomPath;
            VirtualFile atomVF = this.fileCache.get(atomPath);
            if (atomVF == null) {
                if (inJar) {
                    atomVF = childVF.findChild(atom);
                } else {
                    StringBuilder tmp = new StringBuilder(atomPath);
                    File test = new File(tmp.toString());
                    if (test.isFile() && JarImpl.isJar(atom)) {
                        atomVF = new JarImpl(absPath, atomPath);
                        inJar = true;
                    } else {
                        URL atomParentURL = childVF == null ? parentURL : childVF.toURL();
                        String parentString = atomParentURL.toString();
                        if (!parentString.endsWith("/")) {
                            atomParentURL = new URL(parentString + "/");
                        }
                        URL filePath = new URL(atomParentURL, atom);
                        atomVF = new FileImpl(filePath, atomPath, this);
                    }
                }
                this.fileCache.put(atomPath, atomVF);
                childVF = atomVF;
                continue;
            }
            childVF = atomVF;
        }
        return childVF;
    }
}

