/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import org.jboss.vfs.VFSFactory;

public class VFSFactoryLocator {
    private static HashMap<String, VFSFactory> factoryByProtocol = new HashMap();
    private static final String FILE_FACTORY = "org.jboss.vfs.file.DefaultVFSFactory";
    private static boolean initialized;

    public static synchronized void registerFactory(VFSFactory factory) {
        String[] protocols = factory.getProtocols();
        for (int n = 0; n < protocols.length; ++n) {
            String protocol = protocols[n];
            factoryByProtocol.put(protocol, factory);
        }
    }

    public static synchronized VFSFactory getFactory(URL rootURL) throws Exception {
        if (!initialized) {
            VFSFactoryLocator.init();
        }
        String protocol = rootURL.getProtocol();
        VFSFactory factory = factoryByProtocol.get(protocol);
        return factory;
    }

    private static synchronized void init() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> urls = loader.getResources("META-INF/services/org.jboss.vfs.VFSFactory");
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            VFSFactory[] factories = VFSFactoryLocator.loadFactories(url, loader);
            for (int n = 0; n < factories.length; ++n) {
                VFSFactory factory = factories[n];
                VFSFactoryLocator.registerFactory(factory);
            }
        }
        if (factoryByProtocol.size() == 0) {
            Class<?> c = loader.loadClass(FILE_FACTORY);
            VFSFactory factory = (VFSFactory)c.newInstance();
            VFSFactoryLocator.registerFactory(factory);
        }
        initialized = true;
    }

    private static VFSFactory[] loadFactories(URL serviceURL, ClassLoader loader) {
        ArrayList<VFSFactory> tmp = new ArrayList<VFSFactory>();
        try {
            String line;
            InputStream is = serviceURL.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] classes = line.split("\\s+|#.*");
                for (int n = 0; n < classes.length; ++n) {
                    String name = classes[n];
                    if (name.length() == 0) continue;
                    Class<?> factoryClass = loader.loadClass(name);
                    VFSFactory factory = (VFSFactory)factoryClass.newInstance();
                    tmp.add(factory);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        VFSFactory[] factories = new VFSFactory[tmp.size()];
        tmp.toArray(factories);
        return factories;
    }
}

