/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import com.sun.xacml.Policy;
import java.io.InputStream;
import java.net.URL;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.logging.Logger;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityContext;
import org.jboss.security.Util;
import org.jboss.security.authorization.AuthorizationContext;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.plugins.SubjectActions;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;
import org.jboss.util.xml.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JBossAuthorizationManager
implements AuthorizationManager,
PolicyRegistration {
    private CachePolicy domainCache;
    private String securityDomain;
    private Map contextIdToPolicy = new HashMap();
    private static Logger log = Logger.getLogger(JBossAuthorizationManager.class);
    protected boolean trace = log.isTraceEnabled();
    private CallbackHandler callbackHandler = null;
    static /* synthetic */ Class class$org$jboss$security$plugins$JBossAuthorizationManager$AuthorizationCacheEntry;

    public JBossAuthorizationManager(String securityDomainName, CallbackHandler cbh) {
        this.securityDomain = securityDomainName;
        this.callbackHandler = cbh;
    }

    public int authorize(Resource resource) throws AuthorizationException {
        String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        Subject subject = null;
        try {
            subject = (Subject)PolicyContext.getContext(SUBJECT_CONTEXT_KEY);
        }
        catch (PolicyContextException e) {
            log.error("Error obtaining AuthenticatedSubject:", e);
        }
        AuthorizationContext ac = new AuthorizationContext(this.securityDomain, subject, this.callbackHandler);
        return ac.authorize(resource);
    }

    public boolean doesUserHaveRole(Principal principal, Set rolePrincipals) {
        boolean hasRole = false;
        Group roles = this.getCurrentRoles();
        if (this.trace) {
            log.trace("doesUserHaveRole(Set), roles: " + roles);
        }
        if (roles != null) {
            Iterator iter = rolePrincipals.iterator();
            while (!hasRole && iter.hasNext()) {
                Principal role = (Principal)iter.next();
                hasRole = this.doesRoleGroupHaveRole(role, roles);
                if (!this.trace) continue;
                log.trace("hasRole(" + role + ")=" + hasRole);
            }
            if (this.trace) {
                log.trace("hasRole=" + hasRole);
            }
        }
        return hasRole;
    }

    public boolean doesUserHaveRole(Principal principal, Principal role) {
        boolean hasRole = false;
        Group roles = this.getCurrentRoles();
        hasRole = this.doesRoleGroupHaveRole(role, roles);
        return hasRole;
    }

    public boolean doesUserHaveRole(String roleName) {
        throw new IllegalStateException("Not implemented: doesUserHaveRole");
    }

    public Set getUserRoles(Principal principal) {
        Group userRoles = this.getCurrentRoles();
        return this.getRolesAsSet(userRoles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal getPrincipal(Principal principal) {
        this.updateCache(principal);
        Principal result = principal;
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            AuthorizationCacheEntry info = this.getCacheInfo(principal, false);
            if (this.trace) {
                log.trace("getPrincipal, cache info: " + info);
            }
            if (info != null) {
                result = info.callerPrincipal;
                if (result == null) {
                    result = principal;
                }
                info.release();
            }
        }
        return result;
    }

    public void setCachePolicy(CachePolicy domainCache) {
        this.domainCache = domainCache;
        log.debug("CachePolicy set to: " + domainCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthorizationCacheEntry getCacheInfo(Principal principal, boolean allowRefresh) {
        if (this.domainCache == null) {
            return null;
        }
        AuthorizationCacheEntry cacheInfo = null;
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            cacheInfo = allowRefresh ? (AuthorizationCacheEntry)this.domainCache.get(principal) : (AuthorizationCacheEntry)this.domainCache.peek(principal);
            if (cacheInfo != null) {
                cacheInfo.acquire();
            }
        }
        return cacheInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache(Principal principal) {
        Subject theSubject = SubjectActions.getActiveSubject();
        if (theSubject == null) {
            if (this.trace) {
                log.trace("updateCache:Subject on the SecurityAssociation is null");
            }
            return;
        }
        long lifetime = 0L;
        if (this.domainCache instanceof TimedCachePolicy) {
            TimedCachePolicy cache = (TimedCachePolicy)this.domainCache;
            lifetime = cache.getDefaultLifetime();
        }
        AuthorizationCacheEntry info = new AuthorizationCacheEntry(lifetime);
        info.subject = theSubject;
        Set subjectGroups = theSubject.getPrincipals(Group.class);
        Iterator iter = subjectGroups.iterator();
        while (iter.hasNext()) {
            Enumeration members;
            Group grp = (Group)iter.next();
            String name = grp.getName();
            if (!name.equals("CallerPrincipal") || !(members = grp.members()).hasMoreElements()) continue;
            info.callerPrincipal = (Principal)members.nextElement();
        }
        if (principal == null && info.callerPrincipal == null) {
            Set subjectPrincipals = theSubject.getPrincipals(Principal.class);
            iter = subjectPrincipals.iterator();
            while (iter.hasNext()) {
                Principal p = (Principal)iter.next();
                if (p instanceof Group) continue;
                info.callerPrincipal = p;
            }
        }
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            if (this.domainCache.peek(principal) != null) {
                this.domainCache.remove(principal);
            }
            if (info.callerPrincipal != null) {
                this.domainCache.insert(principal, info);
            }
            if (this.trace) {
                log.trace("Inserted cache info: " + info);
            }
        }
    }

    protected boolean doesRoleGroupHaveRole(Principal role, Group userRoles) {
        if (role instanceof NobodyPrincipal) {
            return false;
        }
        boolean isMember = userRoles.isMember(role);
        if (!isMember) {
            isMember = role instanceof AnybodyPrincipal;
        }
        return isMember;
    }

    public void registerPolicy(String contextID, URL location) {
        try {
            if (this.trace) {
                log.trace("Registering policy for contextId:" + contextID + " and location:" + location.getPath());
            }
            this.registerPolicy(contextID, location.openStream());
        }
        catch (Exception e) {
            log.debug("Error in registering xacml policy:", e);
        }
    }

    public void registerPolicy(String contextID, InputStream stream) {
        try {
            Element elm = DOMUtils.parse(stream);
            Policy policy = Policy.getInstance((Node)elm);
            this.contextIdToPolicy.put(contextID, policy);
        }
        catch (Exception e) {
            log.debug("Error in registering xacml policy:", e);
        }
    }

    public void deRegisterPolicy(String contextID) {
        this.contextIdToPolicy.remove(contextID);
        if (this.trace) {
            log.trace("DeRegistered policy for contextId:" + contextID);
        }
    }

    public Object getPolicy(String contextID, Map contextMap) {
        return this.contextIdToPolicy.get(contextID);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[AuthorizationManager:class=").append(this.getClass().getName());
        buf.append(":").append(this.securityDomain).append(":");
        buf.append("]");
        return buf.toString();
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    private HashSet getRolesAsSet(Group roles) {
        HashSet<Principal> userRoles = null;
        if (roles != null) {
            userRoles = new HashSet<Principal>();
            Enumeration members = roles.members();
            while (members.hasMoreElements()) {
                Principal role = (Principal)members.nextElement();
                userRoles.add(role);
            }
        }
        return userRoles;
    }

    private Group getCurrentRoles() {
        Group userRoles;
        boolean emptyContextRoles = false;
        Subject subject = SubjectActions.getActiveSubject();
        Group subjectRoles = Util.getSubjectRoles(subject);
        SecurityContext sc = SecurityAssociation.getSecurityContext();
        if (sc == null) {
            sc = new SecurityContext();
            SecurityAssociation.setSecurityContext(sc);
        }
        if ((userRoles = sc.getRoles(this.securityDomain)) == null) {
            emptyContextRoles = true;
        }
        if (subjectRoles != (userRoles = this.copyGroups(userRoles, subjectRoles)) || emptyContextRoles) {
            sc.setRoles(userRoles, this.securityDomain);
        }
        return sc.getRoles(this.securityDomain);
    }

    private Group copyGroups(Group source, Group toCopy) {
        if (toCopy == null) {
            return source;
        }
        if (source == null && toCopy != null) {
            source = toCopy;
        } else {
            Enumeration en = toCopy.members();
            while (en.hasMoreElements()) {
                source.addMember((Principal)en.nextElement());
            }
        }
        return source;
    }

    public static class AuthorizationCacheEntry
    implements TimedCachePolicy.TimedEntry {
        private static Logger log = Logger.getLogger(class$org$jboss$security$plugins$JBossAuthorizationManager$AuthorizationCacheEntry == null ? (class$org$jboss$security$plugins$JBossAuthorizationManager$AuthorizationCacheEntry = JBossAuthorizationManager.class$("org.jboss.security.plugins.JBossAuthorizationManager$AuthorizationCacheEntry")) : class$org$jboss$security$plugins$JBossAuthorizationManager$AuthorizationCacheEntry);
        private static boolean trace = log.isTraceEnabled();
        private Subject subject;
        private Principal callerPrincipal;
        private long expirationTime;
        private boolean needsDestroy;
        private int activeUsers;

        public AuthorizationCacheEntry(long lifetime) {
            this.expirationTime = lifetime;
            if (this.expirationTime != -1L) {
                this.expirationTime *= 1000L;
            }
        }

        synchronized int acquire() {
            return this.activeUsers++;
        }

        synchronized int release() {
            int users = this.activeUsers--;
            if (this.needsDestroy && users == 0) {
                if (trace) {
                    log.trace("needsDestroy is true, doing logout");
                }
                this.logout();
            }
            return users;
        }

        synchronized void logout() {
            block3: {
                if (trace) {
                    log.trace("logout, subject=" + this.subject + ", this=" + this);
                }
                try {
                    this.subject = null;
                }
                catch (Throwable e) {
                    if (!trace) break block3;
                    log.trace("Cache entry logout failed", e);
                }
            }
        }

        public void init(long now) {
            this.expirationTime += now;
        }

        public boolean isCurrent(long now) {
            boolean isCurrent;
            boolean bl = isCurrent = this.expirationTime == -1L;
            if (!isCurrent) {
                isCurrent = this.expirationTime > now;
            }
            return isCurrent;
        }

        public boolean refresh() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            if (trace) {
                log.trace("destroy, subject=" + this.subject + ", this=" + this + ", activeUsers=" + this.activeUsers);
            }
            AuthorizationCacheEntry authorizationCacheEntry = this;
            synchronized (authorizationCacheEntry) {
                if (this.activeUsers == 0) {
                    this.callerPrincipal = null;
                } else {
                    if (trace) {
                        log.trace("destroy saw activeUsers=" + this.activeUsers);
                    }
                    this.needsDestroy = true;
                }
            }
        }

        public Object getValue() {
            return this;
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer(super.toString());
            tmp.append('[');
            tmp.append(SubjectActions.toString(this.subject));
            tmp.append(",callerPrincipal=");
            tmp.append(this.callerPrincipal);
            tmp.append(",expirationTime=");
            tmp.append(this.expirationTime);
            tmp.append(']');
            return tmp.toString();
        }
    }
}

