/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.sunxacml;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.combine.CombiningAlgFactory;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.PolicyFinderResult;
import com.sun.xacml.support.finder.PolicyCollection;
import com.sun.xacml.support.finder.PolicyReader;
import com.sun.xacml.support.finder.TopLevelPolicyException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.security.authorization.sunxacml.JBossXACMLUtil;

public class JBossStaticPolicyFinderModule
extends PolicyFinderModule {
    private List policyList;
    private PolicyCollection policies;
    private File schemaFile = null;
    private static final String POLICY_ID = "urn:org:jboss:xacml:support:finder:dynamic-policy-set";
    private static URI policyId = JBossXACMLUtil.getDefaultPolicyID();
    private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(JBossStaticPolicyFinderModule.class);
    private boolean trace = log.isTraceEnabled();
    private boolean encounteredParsingException = false;

    public JBossStaticPolicyFinderModule(List policyList) {
        this.policyList = policyList;
        this.policies = new PolicyCollection();
        String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
        if (schemaName != null) {
            this.schemaFile = new File(schemaName);
        }
    }

    public JBossStaticPolicyFinderModule(List policyList, String schemaFile) {
        this.policyList = policyList;
        this.policies = new PolicyCollection();
        if (schemaFile != null) {
            this.schemaFile = new File(schemaFile);
        }
    }

    public JBossStaticPolicyFinderModule(String combiningAlg, List policyList) throws URISyntaxException, UnknownIdentifierException {
        PolicyCombiningAlgorithm alg = (PolicyCombiningAlgorithm)CombiningAlgFactory.getInstance().createAlgorithm(new URI(combiningAlg));
        this.policyList = policyList;
        this.policies = new PolicyCollection(alg, policyId);
        String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
        if (schemaName != null) {
            this.schemaFile = new File(schemaName);
        }
    }

    public JBossStaticPolicyFinderModule(String combiningAlg, List policyList, String schemaFile) throws URISyntaxException, UnknownIdentifierException {
        PolicyCombiningAlgorithm alg = (PolicyCombiningAlgorithm)CombiningAlgFactory.getInstance().createAlgorithm(new URI(combiningAlg));
        this.policyList = policyList;
        this.policies = new PolicyCollection(alg, policyId);
        if (schemaFile != null) {
            this.schemaFile = new File(schemaFile);
        }
    }

    public boolean isRequestSupported() {
        return true;
    }

    public void init(PolicyFinder finder) {
        String clazzName = ((Object)((Object)this)).getClass().getName();
        PolicyReader reader = new PolicyReader(finder, Logger.getLogger(clazzName), this.schemaFile);
        Iterator it = this.policyList.iterator();
        while (it.hasNext()) {
            String str = (String)it.next();
            AbstractPolicy policy = null;
            try {
                try {
                    URL url = new URL(str);
                    policy = reader.readPolicy(url);
                }
                catch (MalformedURLException murle) {
                    policy = reader.readPolicy(new File(str));
                }
            }
            catch (ParsingException e) {
                this.encounteredParsingException = true;
                log.error("Parsing Exception in policy:", e);
                continue;
            }
            if (this.policies.addPolicy(policy)) continue;
            log.warn("tried to load the same policy multiple times: " + str);
        }
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        ArrayList<String> aList = new ArrayList<String>();
        aList.add("urn:oasis:names:tc:xacml:1.0:status:syntax-error");
        try {
            if (this.encounteredParsingException) {
                return new PolicyFinderResult(new Status(aList));
            }
            AbstractPolicy policy = this.policies.getPolicy(context);
            if (policy == null) {
                return new PolicyFinderResult();
            }
            return new PolicyFinderResult(policy);
        }
        catch (TopLevelPolicyException tlpe) {
            return new PolicyFinderResult(tlpe.getStatus());
        }
    }
}

