/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import org.jboss.logging.Logger;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;

public class EJBJACCPolicyModuleDelegate
extends AuthorizationModuleDelegate {
    private String ejbName = null;
    private Method ejbMethod = null;
    private Subject callerSubject = null;
    private String methodInterface = null;
    private CodeSource ejbCS = null;
    private String roleName = null;
    private Boolean roleRefCheck = Boolean.FALSE;

    public EJBJACCPolicyModuleDelegate() {
        log = Logger.getLogger(this.getClass());
        this.trace = log.isTraceEnabled();
    }

    public int authorize(Resource resource) {
        Map map = resource.getMap();
        if (map == null) {
            throw new IllegalStateException("Map from the Resource is null");
        }
        if (map.size() == 0) {
            throw new IllegalStateException("Map from the Resource is size zero");
        }
        PolicyRegistration pr = (PolicyRegistration)map.get("authorizationManager");
        if (pr != null) {
            this.authzManager = pr;
        }
        this.callerSubject = (Subject)map.get("caller.subject");
        this.ejbCS = (CodeSource)map.get("ejb.codeSource");
        this.ejbMethod = (Method)map.get("ejb.method");
        this.ejbName = (String)map.get("ejb.name");
        this.methodInterface = (String)map.get("ejb.methodInterface");
        this.roleName = (String)map.get("roleName");
        this.roleRefCheck = (Boolean)map.get("roleRefPermissionCheck");
        if (this.roleRefCheck == Boolean.TRUE) {
            return this.checkRoleRef();
        }
        return this.process();
    }

    public void setPolicyRegistrationManager(PolicyRegistration authzM) {
        this.authzManager = authzM;
    }

    private int process() {
        EJBMethodPermission methodPerm = new EJBMethodPermission(this.ejbName, this.methodInterface, this.ejbMethod);
        Principal[] principals = null;
        if (this.callerSubject != null) {
            Set<Principal> principalsSet = this.callerSubject.getPrincipals();
            principals = new Principal[principalsSet.size()];
            principalsSet.toArray(principals);
        }
        ProtectionDomain pd = new ProtectionDomain(this.ejbCS, null, null, principals);
        Policy policy = Policy.getPolicy();
        boolean policyDecision = policy.implies(pd, methodPerm);
        if (!policyDecision) {
            String msg = "Denied: " + methodPerm + ", caller=" + this.callerSubject;
            if (this.trace) {
                log.trace("EJB Jacc Delegate:" + msg);
            }
        }
        return policyDecision ? 1 : -1;
    }

    private int checkRoleRef() {
        boolean allowed = false;
        EJBRoleRefPermission ejbRoleRefPerm = new EJBRoleRefPermission(this.ejbName, this.roleName);
        Principal[] principals = null;
        if (this.callerSubject != null) {
            Set<Principal> principalsSet = this.callerSubject.getPrincipals();
            principals = new Principal[principalsSet.size()];
            principalsSet.toArray(principals);
        }
        ProtectionDomain pd = new ProtectionDomain(this.ejbCS, null, null, principals);
        allowed = Policy.getPolicy().implies(pd, ejbRoleRefPerm);
        return allowed ? 1 : -1;
    }
}

