/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.metadata;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.jboss.resource.metadata.AdminObjectMetaData;
import org.jboss.resource.metadata.AuthenticationMechanismMetaData;
import org.jboss.resource.metadata.ConfigPropertyMetaDataContainer;
import org.jboss.resource.metadata.ConnectionDefinitionMetaData;
import org.jboss.resource.metadata.DescriptionGroupMetaData;
import org.jboss.resource.metadata.LicenseMetaData;
import org.jboss.resource.metadata.MessageListenerMetaData;
import org.jboss.resource.metadata.SecurityPermissionMetaData;
import org.jboss.resource.metadata.TransactionSupportMetaData;

public class ConnectorMetaData
extends ConfigPropertyMetaDataContainer {
    private static final long serialVersionUID = -3049391010669865389L;
    private String version = "1.0";
    private String vendorName;
    private String eisType;
    private String raVersion;
    private String raClass;
    private boolean reauthenticationSupport;
    private LicenseMetaData lmd = new LicenseMetaData();
    private ConcurrentReaderHashMap descriptions = new ConcurrentReaderHashMap();
    private HashSet connectionDefinitions = new HashSet();
    private TransactionSupportMetaData tsmd = new TransactionSupportMetaData();
    private AuthenticationMechanismMetaData ammd = new AuthenticationMechanismMetaData();
    private HashSet listeners = new HashSet();
    private HashSet adminObjects = new HashSet();
    private HashSet securityPermissions = new HashSet();

    public ConnectorMetaData() {
        DescriptionGroupMetaData dmd = new DescriptionGroupMetaData();
        this.descriptions.put((Object)dmd.getLanguage(), (Object)dmd);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getEISType() {
        return this.eisType;
    }

    public void setEISType(String eisType) {
        this.eisType = eisType;
    }

    public String getRAVersion() {
        return this.raVersion;
    }

    public void setRAVersion(String version) {
        this.raVersion = version;
    }

    public String getRAClass() {
        return this.raClass;
    }

    public void setRAClass(String raClass) {
        this.raClass = raClass;
    }

    public boolean getReauthenticationSupport() {
        return this.reauthenticationSupport;
    }

    public void setReauthenticationSupport(boolean reauthenticationSupport) {
        this.reauthenticationSupport = reauthenticationSupport;
    }

    public LicenseMetaData getLicense() {
        return this.lmd;
    }

    public DescriptionGroupMetaData getDescription() {
        Iterator i;
        DescriptionGroupMetaData dgmd = (DescriptionGroupMetaData)this.descriptions.get((Object)Locale.getDefault().getLanguage());
        if (dgmd == null && (i = this.descriptions.values().iterator()).hasNext()) {
            dgmd = (DescriptionGroupMetaData)i.next();
        }
        return dgmd;
    }

    public DescriptionGroupMetaData getDescription(String lang) {
        return (DescriptionGroupMetaData)this.descriptions.get((Object)lang);
    }

    public void addDescription(DescriptionGroupMetaData dmd) {
        this.descriptions.put((Object)dmd.getLanguage(), (Object)dmd);
    }

    public TransactionSupportMetaData getTransactionSupport() {
        return this.tsmd;
    }

    public void setTransactionSupport(TransactionSupportMetaData tsmd) {
        this.tsmd = tsmd;
    }

    public AuthenticationMechanismMetaData getAuthenticationMechanism() {
        return this.ammd;
    }

    public void setAuthenticationMechansim(AuthenticationMechanismMetaData ammd) {
        this.ammd = ammd;
    }

    public void addConnectionDefinition(ConnectionDefinitionMetaData cdmd) {
        this.connectionDefinitions.add(cdmd);
    }

    public ConnectionDefinitionMetaData getConnectionDefinition(String connectionDefinition) {
        Iterator i = this.connectionDefinitions.iterator();
        while (i.hasNext()) {
            ConnectionDefinitionMetaData cdmd = (ConnectionDefinitionMetaData)i.next();
            if (!cdmd.getConnectionFactoryInterfaceClass().equals(connectionDefinition)) continue;
            return cdmd;
        }
        return null;
    }

    public void addMessageListener(MessageListenerMetaData mlmd) {
        this.listeners.add(mlmd);
    }

    public MessageListenerMetaData getMessageListener(String messagingType) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            MessageListenerMetaData mlmd = (MessageListenerMetaData)i.next();
            if (!mlmd.getType().equals(messagingType)) continue;
            return mlmd;
        }
        return null;
    }

    public void addAdminObject(AdminObjectMetaData aomd) {
        this.adminObjects.add(aomd);
    }

    public AdminObjectMetaData getAdminObject(String interfaceName) {
        Iterator i = this.adminObjects.iterator();
        while (i.hasNext()) {
            AdminObjectMetaData aomd = (AdminObjectMetaData)i.next();
            if (!aomd.getAdminObjectInterfaceClass().equals(interfaceName)) continue;
            return aomd;
        }
        return null;
    }

    public Collection getAdminObjects() {
        return this.adminObjects;
    }

    public void addSecurityPermission(SecurityPermissionMetaData spmd) {
        this.securityPermissions.add(spmd);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ConnectorMetaData").append('@');
        buffer.append(Integer.toHexString(System.identityHashCode(this)));
        buffer.append("[version=").append(this.version);
        buffer.append(" vendorName=").append(this.vendorName);
        buffer.append(" eisType=").append(this.eisType);
        buffer.append(" resourceAdapterVersion=").append(this.raVersion);
        buffer.append(" resourceAdapterClass=").append(this.raClass);
        buffer.append(" license=").append(this.lmd);
        buffer.append(" properties=").append(this.getProperties());
        buffer.append(" descriptions=").append(this.descriptions.values());
        buffer.append(" connectionDefinitions=").append(this.connectionDefinitions);
        buffer.append(" transactionSupport=").append(this.tsmd);
        buffer.append(" authenticationMechanism=").append(this.ammd);
        buffer.append(" reauthenticationSupport=").append(this.reauthenticationSupport);
        buffer.append(" messageListeners=").append(this.listeners);
        buffer.append(" adminobjects=").append(this.adminObjects);
        buffer.append(" securityPermissions=").append(this.securityPermissions);
        buffer.append(']');
        return buffer.toString();
    }
}

