/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployment.ds;

import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.resource.deployment.ds.metadata.AvailabilitySupportMetaData;
import org.jboss.resource.deployment.ds.metadata.ConnectionFactoryMetaData;
import org.jboss.resource.deployment.ds.metadata.ConnectionFactoryMetaDataFactory;
import org.jboss.resource.deployment.ds.metadata.ConnectionPoolMetaData;
import org.jboss.resource.deployment.ds.metadata.DataSourceMetaData;
import org.jboss.resource.deployment.ds.metadata.DsDefinitionMetaData;
import org.jboss.resource.deployment.ds.metadata.DsMetaData;
import org.jboss.resource.deployment.ds.metadata.DsPropertyMetaData;
import org.jboss.resource.deployment.ds.metadata.PoolCriteriaMetaData;
import org.jboss.resource.deployment.ds.metadata.SqlSupportMetaData;
import org.jboss.resource.deployment.ds.metadata.TransactionSupportFactory;
import org.jboss.resource.deployment.ds.metadata.TransactionSupportMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class DsObjectModelFactory
implements ObjectModelFactory {
    private static final Logger log = Logger.getLogger(DsObjectModelFactory.class);
    private static final List connectionPoolElementNames = new ArrayList();
    private static final List sqlSupportElementNames = new ArrayList();
    private static final List criteriaSupportElementNames = new ArrayList();
    private static final List txnSupportElementnames = new ArrayList();
    private static final List availablitySupportElementNames = new ArrayList();
    private boolean trace = log.isTraceEnabled();

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        this.checkRoot(localName);
        DsMetaData md = new DsMetaData();
        DsDefinitionMetaData dsdmd = ConnectionFactoryMetaDataFactory.getDefinitionMetaData(localName);
        md.setDsDefinitionMetaData(dsdmd);
        return dsdmd;
    }

    public Object newChild(DsDefinitionMetaData md, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        ConnectionFactoryMetaData abmd = ConnectionFactoryMetaDataFactory.getFactoryMetaData(localName);
        md.addDsDefinition(abmd);
        return abmd;
    }

    public Object addChild(DsDefinitionMetaData md, ConnectionFactoryMetaData cfmd, UnmarshallingContext navigator, String namespaceURI, String localName) {
        if (txnSupportElementnames.contains(localName)) {
            TransactionSupportMetaData txmd = this.handleTransactionSupportMetaData(cfmd, localName);
            cfmd.setTxnSupport(txmd);
        }
        return cfmd;
    }

    public Object addChild(DsDefinitionMetaData md, DataSourceMetaData dsmd, UnmarshallingContext navigator, String namespaceURI, String localName) {
        if (txnSupportElementnames.contains(localName)) {
            TransactionSupportMetaData txmd = this.handleTransactionSupportMetaData(dsmd, localName);
            dsmd.setTxnSupport(txmd);
        }
        if (availablitySupportElementNames.contains(localName)) {
            AvailabilitySupportMetaData amd = this.handleAvailabilitySupportMetaData(dsmd, localName);
            dsmd.setAvailabilitySupport(amd);
        }
        if (localName.equals("no-tx-datasource") || localName.equals("local-tx-datasource")) {
            dsmd.setRarName("jboss-local-jdbc.rar");
            dsmd.setConnectionDefintion("javax.sql.DataSource");
        } else if (localName.equals("xa-tx-datasource")) {
            dsmd.setRarName("jboss-xa-jdbc.rar");
            dsmd.setConnectionDefintion("javax.sql.DataSource");
        } else if (localName.equals("ha-local-tx-datasource")) {
            dsmd.setRarName("jboss-ha-local-jdbc.rar");
            dsmd.setConnectionDefintion("javax.sql.DataSource");
        } else if (localName.equals("ha-xa-datasource")) {
            dsmd.setRarName("jboss-ha-xa-jdbc.rar");
            dsmd.setConnectionDefintion("javax.sql.DataSource");
        }
        return dsmd;
    }

    public Object newChild(ConnectionFactoryMetaData cfmd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("config-property")) {
            DsPropertyMetaData pmd = this.handlePropertyMetaData(localName, attrs);
            cfmd.addProperty(pmd);
            return pmd;
        }
        if (connectionPoolElementNames.contains(localName)) {
            return this.handlePoolMetaData(cfmd);
        }
        if (criteriaSupportElementNames.contains(localName)) {
            return this.handlePoolCriteriaMetaData(cfmd, localName);
        }
        if (localName.equals("local-transaction") || localName.equals("xa-transaction")) {
            cfmd.setTxnSupport(TransactionSupportFactory.getTransactionSupport(localName));
        }
        return null;
    }

    public Object newChild(DataSourceMetaData dsmd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("connection-property") || localName.equals("xa-datasource-property")) {
            DsPropertyMetaData pmd = this.handlePropertyMetaData(localName, attrs);
            dsmd.addProperty(pmd);
            return pmd;
        }
        if (sqlSupportElementNames.contains(localName)) {
            return this.handleSqlSupportMetaData(dsmd);
        }
        if (connectionPoolElementNames.contains(localName)) {
            return this.handlePoolMetaData(dsmd);
        }
        if (criteriaSupportElementNames.contains(localName)) {
            return this.handlePoolCriteriaMetaData(dsmd, localName);
        }
        return null;
    }

    public void setValue(DsPropertyMetaData dsmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        dsmd.setValue(value);
    }

    public void setValue(ConnectionFactoryMetaData cfmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("jndi-name")) {
            cfmd.setJndiName(value);
        } else if (localName.equals("use-java-context")) {
            cfmd.setUseJavaConext(Boolean.valueOf(localName));
        } else if (localName.equals("connection-definition")) {
            cfmd.setConnectionDefintion(localName);
        }
    }

    public void setValue(DataSourceMetaData dsmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("jndi-name")) {
            dsmd.setJndiName(value);
        } else if (localName.equals("use-java-context")) {
            dsmd.setUseJavaConext(Boolean.valueOf(localName));
        } else if (localName.equals("connection-definition")) {
            dsmd.setConnectionDefintion(localName);
        } else if (localName.equals("xa-datasource-class")) {
            dsmd.setDriverClass(value);
        } else if (localName.equals("isSameRM-override-value")) {
            dsmd.setSameRMOverride(Boolean.valueOf(value));
        } else if (localName.equals("type-mapping")) {
            dsmd.setTypeMapping(value);
        } else if (localName.equals("username")) {
            dsmd.setUserName(value);
        } else if (localName.equals("password")) {
            dsmd.setPassWord(value);
        } else if (localName.equals("connection-url")) {
            dsmd.setConnectionUrl(value);
        } else if (localName.equals("driver-class") || localName.equals("xa-datasource-class")) {
            dsmd.setDriverClass(value);
        } else if (localName.equals("url-delimeter")) {
            dsmd.getAvailabilitySupport().setUrlDelimeter(value);
        } else if (localName.equals("url-property")) {
            dsmd.getAvailabilitySupport().setUrlProperty(value);
        }
    }

    public void setValue(ConnectionPoolMetaData cpmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("min-pool-size")) {
            cpmd.setMinPoolSize(Integer.valueOf(value));
        } else if (localName.equals("max-pool-size")) {
            cpmd.setMaxPoolSize(Integer.valueOf(value));
        } else if (localName.equals("blocking-timeout-millis")) {
            cpmd.setBlockingTimeoutMilliseconds(Long.valueOf(value));
        } else if (localName.equals("idle-timeout-minutes")) {
            cpmd.setIdleTimeoutMinutes(Integer.valueOf(value).intValue());
        } else if (localName.equals("security-damain") || localName.equals("application-managed-security") || localName.equals("security-domain-and-application")) {
            cpmd.setPoolCriteria(PoolCriteriaMetaData.fromDsElement(localName));
        } else if (localName.equals("background-validation")) {
            cpmd.setBackgroundValidation(Boolean.valueOf(value));
        } else if (localName.equals("background-validation-interval")) {
            cpmd.setBackgroundValidationInterval(Integer.valueOf(value));
        } else if (localName.equals("no-tx-separate-pools")) {
            cpmd.setNoTxSeperatePool(Boolean.valueOf(value));
        } else if (localName.equals("prefill")) {
            cpmd.setPrefill(Boolean.valueOf(value));
        } else {
            throw new IllegalArgumentException("Unknown connection pool setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
        }
    }

    public void setValue(SqlSupportMetaData sqlmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("prepared-statement-cache-size")) {
            sqlmd.setPreparedStatementCacheSize(new Integer(value));
        } else if (localName.equals("share-prepared-statements")) {
            sqlmd.setShareStatements(Boolean.valueOf(value));
        } else if (localName.equals("track-statements")) {
            sqlmd.setTrackStatements(Boolean.valueOf(value));
        } else if (localName.equals("new-connection-sql")) {
            sqlmd.setNewConnectionSql(value);
        } else if (localName.equals("check-valid-connection-sql")) {
            sqlmd.setCheckValidConnectionSql(value);
        } else if (localName.equals("valid-connection-checker-class-name")) {
            sqlmd.setValidConnectionCheckerClassName(value);
        } else if (localName.equals("exception-sorter-class-name")) {
            sqlmd.setExceptionSorterClassName(value);
        } else if (localName.equals("query-timeout")) {
            sqlmd.setQueryTimeout(Integer.valueOf(value));
        } else if (localName.equals("set-tx-query-timeout")) {
            sqlmd.setTxQueryTimeout(true);
        } else if (localName.equals("track-statements")) {
            if (value.equals("nowarn")) {
                sqlmd.setTrackStatements(Boolean.TRUE);
                sqlmd.setTrackStatementsNoWarn(Boolean.TRUE);
            } else if (value.equals("true")) {
                sqlmd.setTrackStatements(Boolean.TRUE);
            }
        }
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    private void checkRoot(String localName) {
        if (!localName.equals("datasources") && !localName.equals("connection-factories")) {
            throw new IllegalStateException("Unexpected root element: was expecting 'datasources' or 'connection-factories' but got '" + localName + "'");
        }
    }

    private DsPropertyMetaData handlePropertyMetaData(String localName, Attributes attrs) {
        DsPropertyMetaData pmd = new DsPropertyMetaData();
        if (attrs != null && attrs.getLength() > 0) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (attrs.getLocalName(i).equals("name")) {
                    pmd.setName(attrs.getValue(i));
                }
                if (!attrs.getLocalName(i).equals("type")) continue;
                pmd.setType(attrs.getValue(i));
            }
        }
        return pmd;
    }

    private ConnectionPoolMetaData handlePoolCriteriaMetaData(ConnectionFactoryMetaData cfmd, String localName) {
        ConnectionPoolMetaData cpmd = cfmd.getPoolMetaData();
        if (cpmd == null) {
            cpmd = new ConnectionPoolMetaData();
        }
        if (cpmd.getPoolCriteria().equals(PoolCriteriaMetaData.NOTHING)) {
            PoolCriteriaMetaData pcmd = PoolCriteriaMetaData.fromDsElement(localName);
            cpmd.setPoolCriteria(pcmd);
        }
        return cpmd;
    }

    private ConnectionPoolMetaData handlePoolMetaData(ConnectionFactoryMetaData cfmd) {
        ConnectionPoolMetaData cpmd = cfmd.getPoolMetaData();
        if (cpmd == null) {
            cpmd = new ConnectionPoolMetaData();
            cfmd.setPoolMetaData(cpmd);
        }
        return cpmd;
    }

    private SqlSupportMetaData handleSqlSupportMetaData(DataSourceMetaData dsmd) {
        SqlSupportMetaData sqlmd = dsmd.getSqlSupport();
        if (sqlmd == null) {
            sqlmd = new SqlSupportMetaData();
            dsmd.setSqlSupportMetaData(sqlmd);
        }
        return sqlmd;
    }

    private TransactionSupportMetaData handleTransactionSupportMetaData(ConnectionFactoryMetaData cfmd, String localName) {
        TransactionSupportMetaData txmd = cfmd.getTxnSupport();
        if (txmd == null) {
            txmd = TransactionSupportMetaData.fromString(localName);
            cfmd.setTxnSupport(txmd);
        }
        return txmd;
    }

    private AvailabilitySupportMetaData handleAvailabilitySupportMetaData(DataSourceMetaData dsmd, String localName) {
        AvailabilitySupportMetaData amd = dsmd.getAvailabilitySupport();
        if (amd == null || amd.equals(AvailabilitySupportMetaData.NONE)) {
            amd = AvailabilitySupportMetaData.fromString(localName);
        }
        return amd;
    }

    static {
        connectionPoolElementNames.add("min-pool-size");
        connectionPoolElementNames.add("max-pool-size");
        connectionPoolElementNames.add("blocking-timeout-millis");
        connectionPoolElementNames.add("idle-timeout-minutes");
        connectionPoolElementNames.add("prefill");
        connectionPoolElementNames.add("background-validation");
        connectionPoolElementNames.add("background-validtion-interval");
        connectionPoolElementNames.add("validate-on-match");
        connectionPoolElementNames.add("no-tx-separate-pools");
        sqlSupportElementNames.add("new-connection-sql");
        sqlSupportElementNames.add("check-valid-connection-sql");
        sqlSupportElementNames.add("valid-connection-checker-class-name");
        sqlSupportElementNames.add("exception-sorter-class-name");
        sqlSupportElementNames.add("prepared-statement-cache-size");
        sqlSupportElementNames.add("share-prepared-statements");
        sqlSupportElementNames.add("track-statements");
        sqlSupportElementNames.add("query-timeout");
        sqlSupportElementNames.add("set-tx-query-timeout");
        sqlSupportElementNames.add("transaction-isolation");
        criteriaSupportElementNames.add("application-managed-security");
        criteriaSupportElementNames.add("security-domain");
        criteriaSupportElementNames.add("security-domain-and-application");
        txnSupportElementnames.add("no-tx-datasource");
        txnSupportElementnames.add("local-tx-datasource");
        txnSupportElementnames.add("xa-datasource");
        txnSupportElementnames.add("no-tx-connection-factory");
        txnSupportElementnames.add("tx-connection-factory");
        txnSupportElementnames.add("ha-local-tx-datasource");
        txnSupportElementnames.add("ha-xa-datasource");
        availablitySupportElementNames.add("ha-local-tx-datasource");
        availablitySupportElementNames.add("ha-xa-datasource");
    }
}

