/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.resource.connectionmanager.xa.JcaXid;

public class XAResourceWrapper
implements XAResource {
    private XAResource resource;
    private boolean pad;
    private boolean override;
    private boolean rmOverride;

    public XAResourceWrapper(XAResource resource) {
        this(false, false, resource);
    }

    public XAResourceWrapper(boolean pad, XAResource resource) {
        this(false, pad, resource);
    }

    public XAResourceWrapper(boolean override, boolean pad, XAResource resource) {
        this.override = override;
        this.pad = pad;
        this.resource = resource;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        xid = this.convertXid(xid);
        this.resource.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        xid = this.convertXid(xid);
        this.resource.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        this.resource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.resource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (this.override) {
            return this.rmOverride;
        }
        return resource.isSameRM(resource);
    }

    public int prepare(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        return this.resource.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.resource.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this.resource.rollback(xid);
    }

    public boolean setTransactionTimeout(int flag) throws XAException {
        return this.resource.setTransactionTimeout(flag);
    }

    public void start(Xid xid, int flags) throws XAException {
        this.resource.start(xid, flags);
    }

    private Xid convertXid(Xid xid) {
        if (xid instanceof JcaXid) {
            return xid;
        }
        return new JcaXid(this.pad, xid);
    }
}

