/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.compress;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class CompressingMarshaller
extends SerializableMarshaller {
    public static final String DATATYPE = "compressible";
    private Marshaller wrappedMarshaller;

    public CompressingMarshaller() {
    }

    public CompressingMarshaller(Marshaller marshaller) {
        this.wrappedMarshaller = marshaller;
    }

    public void write(Object dataObject, OutputStream output) throws IOException {
        output.flush();
        GZIPOutputStream gzos = new GZIPOutputStream(output);
        ObjectOutputStream oos = SerializationStreamFactory.getManagerInstance(this.getSerializationType()).createOutput(gzos);
        if (this.wrappedMarshaller != null) {
            this.wrappedMarshaller.write(dataObject, oos);
        } else {
            super.write(dataObject, oos);
        }
        gzos.finish();
        oos.flush();
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        return new CompressingMarshaller(this.wrappedMarshaller);
    }
}

