/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.jboss.reflect.plugins.ClassInfoHelper;
import org.jboss.reflect.plugins.ConstructorInfoImpl;
import org.jboss.reflect.plugins.FieldInfoImpl;
import org.jboss.reflect.plugins.InheritableAnnotationHolder;
import org.jboss.reflect.plugins.MethodInfoImpl;
import org.jboss.reflect.plugins.ValueConvertor;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.UnreachableStatementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoImpl
extends InheritableAnnotationHolder
implements ClassInfo {
    private static final long serialVersionUID = 3545798779904340792L;
    static final ClassInfo UNKNOWN_CLASS = new UnknownClassInfo();
    static final InterfaceInfo[] UNKNOWN_INTERFACES = new InterfaceInfo[0];
    static final ConstructorInfo[] UNKNOWN_CONSTRUCTORS = new ConstructorInfo[0];
    static final MethodInfo[] UNKNOWN_METHODS = new MethodInfo[0];
    private static final FieldInfo[] UNKNOWN_FIELDS = new FieldInfo[0];
    protected String name;
    protected int modifiers;
    protected InterfaceInfo[] interfaces = UNKNOWN_INTERFACES;
    protected MethodInfo[] methods = UNKNOWN_METHODS;
    protected FieldInfo[] fields = UNKNOWN_FIELDS;
    protected HashMap fieldMap;
    protected ClassInfo superclass = UNKNOWN_CLASS;
    protected ConstructorInfo[] constructors = UNKNOWN_CONSTRUCTORS;
    protected ClassInfoHelper classInfoHelper;

    public static MethodInfo findMethod(MethodInfo[] methods, String name, TypeInfo[] parameters) {
        if (methods == null) {
            return null;
        }
        for (int i = 0; i < methods.length; ++i) {
            int length;
            if (!methods[i].getName().equals(name)) continue;
            int n = length = parameters != null ? parameters.length : 0;
            if (methods[i].getParameterTypes().length != length) continue;
            boolean ok = true;
            for (int j = 0; j < length; ++j) {
                if (parameters[j].equals(methods[i].getParameterTypes()[j])) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return methods[i];
        }
        return null;
    }

    public static Class getArrayClass(Class clazz, int depth) {
        return Array.newInstance(clazz, depth).getClass();
    }

    public ClassInfoImpl() {
    }

    public ClassInfoImpl(String name) {
        this.name = name;
    }

    public ClassInfoImpl(String name, int modifiers, InterfaceInfo[] interfaces, ClassInfoImpl superclass) {
        this.name = name;
        this.modifiers = modifiers;
        this.interfaces = interfaces;
        this.superclass = superclass;
    }

    public void setClassInfoHelper(ClassInfoHelper helper) {
        this.classInfoHelper = helper;
    }

    public void setType(Class type) {
        this.setAnnotatedElement(type);
    }

    public void setInterfaces(InterfaceInfo[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setDeclaredMethods(MethodInfoImpl[] methods) {
        this.methods = methods;
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                methods[i].declaringClass = this;
            }
        }
    }

    public void setDeclaredFields(FieldInfoImpl[] fields) {
        this.fields = fields;
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                fields[i].declaringClass = this;
            }
        }
    }

    public void setDeclaredConstructors(ConstructorInfoImpl[] constructors) {
        this.constructors = constructors;
        if (constructors != null) {
            for (int i = 0; i < constructors.length; ++i) {
                constructors[i].declaringClass = this;
            }
        }
    }

    public void setSuperclass(ClassInfoImpl superInfo) {
        this.superclass = superInfo;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public InterfaceInfo[] getInterfaces() {
        if (this.interfaces == UNKNOWN_INTERFACES) {
            this.setInterfaces(this.classInfoHelper.getInterfaces(this));
        }
        return this.interfaces;
    }

    @Override
    public MethodInfo getDeclaredMethod(String name, TypeInfo[] parameters) {
        if (this.methods == UNKNOWN_METHODS) {
            this.setDeclaredMethods(this.classInfoHelper.getMethods(this));
        }
        return ClassInfoImpl.findMethod(this.methods, name, parameters);
    }

    @Override
    public MethodInfo[] getDeclaredMethods() {
        if (this.methods == UNKNOWN_METHODS) {
            this.setDeclaredMethods(this.classInfoHelper.getMethods(this));
        }
        return this.methods;
    }

    @Override
    public FieldInfo getDeclaredField(String name) {
        if (this.fields == UNKNOWN_FIELDS) {
            this.setDeclaredFields(this.classInfoHelper.getFields(this));
        }
        return (FieldInfo)this.fieldMap.get(name);
    }

    @Override
    public FieldInfo[] getDeclaredFields() {
        if (this.fields == UNKNOWN_FIELDS) {
            this.setDeclaredFields(this.classInfoHelper.getFields(this));
        }
        return this.fields;
    }

    @Override
    public ConstructorInfo[] getDeclaredConstructors() {
        if (this.constructors == UNKNOWN_CONSTRUCTORS) {
            this.setDeclaredConstructors(this.classInfoHelper.getConstructors(this));
        }
        return this.constructors;
    }

    @Override
    public ClassInfo getSuperclass() {
        if (this.superclass == UNKNOWN_CLASS) {
            this.setSuperclass(this.classInfoHelper.getSuperClass(this));
        }
        return this.superclass;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<? extends Object> getType() {
        return (Class)this.annotatedElement;
    }

    @Override
    public Object convertValue(Object value) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value);
    }

    @Override
    public boolean isArray() {
        return this.getType().isArray();
    }

    @Override
    public TypeInfo getArrayType(int depth) {
        Class arrayClass = ClassInfoImpl.getArrayClass(this.getType(), depth);
        return this.classInfoHelper.getTypeInfo(arrayClass);
    }

    @Override
    public Object[] newArrayInstance(int size) throws Throwable {
        Class<? extends Object> clazz = this.getType();
        if (!clazz.isArray()) {
            throw new ClassCastException(clazz + " is not an array.");
        }
        return (Object[])Array.newInstance(clazz.getComponentType(), size);
    }

    @Override
    protected InheritableAnnotationHolder getSuperHolder() {
        return (ClassInfoImpl)this.getSuperclass();
    }

    @Override
    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ClassInfo)) {
            return false;
        }
        ClassInfo other = (ClassInfo)obj;
        return !(this.name != null ? !this.name.equals(other.getName()) : other.getName() != null);
    }

    @Override
    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    static class UnknownClassInfo
    implements ClassInfo {
        UnknownClassInfo() {
        }

        public ConstructorInfo[] getDeclaredConstructors() {
            throw new UnreachableStatementException();
        }

        public FieldInfo getDeclaredField(String name) {
            throw new UnreachableStatementException();
        }

        public FieldInfo[] getDeclaredFields() {
            throw new UnreachableStatementException();
        }

        public MethodInfo getDeclaredMethod(String name, TypeInfo[] parameters) {
            throw new UnreachableStatementException();
        }

        public MethodInfo[] getDeclaredMethods() {
            throw new UnreachableStatementException();
        }

        public InterfaceInfo[] getInterfaces() {
            throw new UnreachableStatementException();
        }

        public String getName() {
            throw new UnreachableStatementException();
        }

        public ClassInfo getSuperclass() {
            throw new UnreachableStatementException();
        }

        public boolean isInterface() {
            throw new UnreachableStatementException();
        }

        public AnnotationValue getAnnotation(String name) {
            throw new UnreachableStatementException();
        }

        public AnnotationValue[] getAnnotations() {
            throw new UnreachableStatementException();
        }

        public boolean isAnnotationPresent(String name) {
            throw new UnreachableStatementException();
        }

        public String toShortString() {
            throw new UnreachableStatementException();
        }

        public void toShortString(JBossStringBuilder buffer) {
            throw new UnreachableStatementException();
        }

        public Class getType() {
            throw new UnreachableStatementException();
        }

        public Object convertValue(Object value) throws Throwable {
            throw new UnreachableStatementException();
        }

        public TypeInfo getArrayType(int depth) {
            throw new UnreachableStatementException();
        }

        public boolean isArray() {
            throw new UnreachableStatementException();
        }

        public Object[] newArrayInstance(int size) throws Throwable {
            throw new UnreachableStatementException();
        }

        public int getModifiers() {
            throw new UnreachableStatementException();
        }

        public boolean isPublic() {
            throw new UnreachableStatementException();
        }

        public boolean isStatic() {
            throw new UnreachableStatementException();
        }

        public Object clone() {
            throw new UnreachableStatementException();
        }
    }
}

