/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EjbModule;
import org.jboss.naming.JNDIViewMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.web.AbstractWebDeployerMBean;
import org.jboss.web.WebApplication;

public class JNDIView
extends ServiceMBeanSupport
implements JNDIViewMBean {
    protected static final String[] g_haAttributes = new String[]{"BindAddress", "Port"};
    protected String haNamingService;

    public String list(boolean verbose) {
        StringBuffer buffer = new StringBuffer(4096);
        Context context = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Iterator it = (Iterator)this.server.getAttribute(AbstractWebDeployerMBean.OBJECT_NAME, "DeployedApplications");
            if (it.hasNext()) {
                buffer.append("<h1>Web Applications</h1>\n");
            }
            while (it.hasNext()) {
                WebApplication webApplication = (WebApplication)it.next();
                Thread.currentThread().setContextClassLoader(webApplication.getMetaData().getENCLoader());
                buffer.append("<h2>java:comp namespace of the " + webApplication.getDeploymentInfo().getCanonicalName() + " application:</h2>\n");
                try {
                    context = new InitialContext();
                    context = (Context)context.lookup("java:comp");
                }
                catch (NamingException e) {
                    buffer.append("Failed on lookup, " + e.toString(true));
                    this.formatException(buffer, e);
                    continue;
                }
                buffer.append("<pre>\n");
                this.list(context, " ", buffer, verbose);
                buffer.append("</pre>\n");
            }
        }
        catch (Throwable e) {
            this.log.debug("Unable to list web applications ENC", e);
        }
        Set ejbModules = null;
        try {
            ejbModules = this.server.queryNames(EjbModule.EJB_MODULE_QUERY_NAME, null);
        }
        catch (Throwable e) {
            this.log.error("getDeployedApplications failed", e);
            buffer.append("Failed to getDeployedApplications\n");
            this.formatException(buffer, e);
            buffer.insert(0, "<pre>");
            buffer.append("</pre>");
            return buffer.toString();
        }
        for (ObjectName app : ejbModules) {
            String module = app.getKeyProperty("module");
            if (module == null) {
                module = app.toString();
            }
            buffer.append("<h1>Ejb Module: " + module + "</h1>\n");
            try {
                Collection containers = (Collection)this.server.getAttribute(app, "Containers");
                for (Container con : containers) {
                    Thread.currentThread().setContextClassLoader(con.getClassLoader());
                    String bean = con.getBeanMetaData().getEjbName();
                    buffer.append("<h2>java:comp namespace of the " + bean + " bean:</h2>\n");
                    try {
                        context = new InitialContext();
                        context = (Context)context.lookup("java:comp");
                    }
                    catch (NamingException e) {
                        buffer.append("Failed on lookup, " + e.toString(true));
                        this.formatException(buffer, e);
                        continue;
                    }
                    buffer.append("<pre>\n");
                    this.list(context, " ", buffer, verbose);
                    buffer.append("</pre>\n");
                }
            }
            catch (Throwable e) {
                this.log.error("getConainers failed", e);
                buffer.append("<pre>");
                buffer.append("Failed to get ejbs in module\n");
                this.formatException(buffer, e);
                buffer.append("</pre>");
            }
        }
        Thread.currentThread().setContextClassLoader(currentLoader);
        try {
            context = new InitialContext();
            context = (Context)context.lookup("java:");
            buffer.append("<h1>java: Namespace</h1>\n");
            buffer.append("<pre>\n");
            this.list(context, " ", buffer, verbose);
            buffer.append("</pre>\n");
        }
        catch (NamingException e) {
            this.log.error("lookup for java: failed", e);
            buffer.append("Failed to get InitialContext, " + e.toString(true));
            this.formatException(buffer, e);
        }
        try {
            context = new InitialContext();
            buffer.append("<h1>Global JNDI Namespace</h1>\n");
            buffer.append("<pre>\n");
            this.list(context, " ", buffer, verbose);
            buffer.append("</pre>\n");
        }
        catch (NamingException e) {
            this.log.error("Failed to get InitialContext", e);
            buffer.append("Failed to get InitialContext, " + e.toString(true));
            this.formatException(buffer, e);
        }
        try {
            String url = this.getHAUrl();
            if (url != null) {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.provider.url", url);
                context = new InitialContext(env);
                buffer.append("<h1>HA-JNDI Namespace</h1>\n");
                buffer.append("<pre>\n");
                this.list(context, " ", buffer, verbose);
                buffer.append("</pre>\n");
            }
        }
        catch (NamingException ne) {
            this.log.error("Failed to get InitialContext", ne);
            buffer.append("Failed to get InitialContext, " + ne.toString(true));
            this.formatException(buffer, ne);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listXML() {
        StringBuffer buffer = new StringBuffer(4096);
        Set ejbModules = null;
        Context context = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        this.openJndiTag(buffer);
        try {
            Iterator it = (Iterator)this.server.getAttribute(AbstractWebDeployerMBean.OBJECT_NAME, "DeployedApplications");
            while (it.hasNext()) {
                WebApplication webApplication = (WebApplication)it.next();
                this.openWebModuleTag(buffer, webApplication.getDeploymentInfo().getCanonicalName());
                Thread.currentThread().setContextClassLoader(webApplication.getMetaData().getENCLoader());
                try {
                    context = new InitialContext();
                    context = (Context)context.lookup("java:comp");
                    this.listXML(context, buffer);
                }
                catch (NamingException e) {
                    buffer.append("Failed on lookup, " + e.toString(true));
                    this.formatException(buffer, e);
                }
                finally {
                    this.closeWebModuleTag(buffer);
                }
            }
        }
        catch (Throwable e) {
            this.log.debug("Unable to list web applications ENC", e);
        }
        try {
            ejbModules = this.server.queryNames(EjbModule.EJB_MODULE_QUERY_NAME, null);
        }
        catch (Exception e) {
            this.log.error("getDeployedApplications failed", e);
            this.appendErrorTag(buffer, "Failed to getDeployedApplications " + e.toString());
            this.closeJndiTag(buffer);
            return buffer.toString();
        }
        for (ObjectName app : ejbModules) {
            this.openEjbModuleTag(buffer, app.getKeyProperty("url"));
            this.listModuleContainers(buffer, app);
            this.closeEjbModuleTag(buffer);
        }
        Thread.currentThread().setContextClassLoader(currentLoader);
        try {
            context = new InitialContext();
            context = (Context)context.lookup("java:");
        }
        catch (NamingException e) {
            this.log.error("Failed to get InitialContext for (java:)", e);
            this.appendErrorTag(buffer, "Failed to get InitialContext for (java:), " + e.toString(true));
        }
        if (context != null) {
            this.openContextTag(buffer);
            this.appendJavaNameTag(buffer);
            try {
                this.listXML(context, buffer);
            }
            catch (Throwable t) {
                this.log.error("Failed to list contents of (java:)", t);
                this.appendErrorTag(buffer, "Failed to list contents of (java:), " + t.toString());
            }
            this.closeContextTag(buffer);
        }
        try {
            context = new InitialContext();
        }
        catch (NamingException e) {
            this.log.error("Failed to get InitialContext", e);
            this.appendErrorTag(buffer, "Failed to get InitialContext, " + e.toString(true));
        }
        if (context != null) {
            this.openContextTag(buffer);
            this.appendGlobalNameTag(buffer);
            try {
                this.listXML(context, buffer);
            }
            catch (Throwable t) {
                this.log.error("Failed to list global contents ", t);
                this.appendErrorTag(buffer, "Failed to list global contents, " + t.toString());
            }
            this.closeContextTag(buffer);
        }
        String url = null;
        try {
            url = this.getHAUrl();
            if (url != null) {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.provider.url", url);
                context = new InitialContext(env);
            }
        }
        catch (NamingException e) {
            this.log.error("Failed to get InitialContext", e);
            this.appendErrorTag(buffer, "Failed to get InitialContext, " + e.toString(true));
        }
        if (url != null && context != null) {
            this.openContextTag(buffer);
            this.appendHANameTag(buffer);
            try {
                this.listXML(context, buffer);
            }
            catch (Throwable t) {
                this.log.error("Failed to list HA-JNDI contents ", t);
                this.appendErrorTag(buffer, "Failed to list HA-JNDI contents, " + t.toString());
            }
            this.closeContextTag(buffer);
        }
        this.closeJndiTag(buffer);
        return buffer.toString();
    }

    public String getHANamingService() {
        return this.haNamingService;
    }

    public void setHANamingService(String serviceName) {
        this.haNamingService = serviceName;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    private void list(Context ctx, String indent, StringBuffer buffer, boolean verbose) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            NamingEnumeration<NameClassPair> ne = ctx.list("");
            while (ne.hasMore()) {
                Class<?> c;
                boolean isProxy;
                boolean isLinkRef;
                boolean recursive;
                String className;
                String name;
                NameClassPair pair;
                block21: {
                    pair = ne.next();
                    this.log.trace("pair: " + pair);
                    name = pair.getName();
                    className = pair.getClassName();
                    recursive = false;
                    isLinkRef = false;
                    isProxy = false;
                    c = null;
                    try {
                        c = loader.loadClass(className);
                        this.log.trace("type: " + c);
                        if (Context.class.isAssignableFrom(c)) {
                            recursive = true;
                        }
                        if (LinkRef.class.isAssignableFrom(c)) {
                            isLinkRef = true;
                        }
                        isProxy = Proxy.isProxyClass(c);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (!className.startsWith("$Proxy")) break block21;
                        isProxy = true;
                        try {
                            Object p = ctx.lookup(name);
                            c = p.getClass();
                        }
                        catch (NamingException e) {
                            String msg;
                            Throwable t = e.getRootCause();
                            if (!(t instanceof ClassNotFoundException) || (msg = t.getMessage()) == null) break block21;
                            className = msg;
                        }
                    }
                }
                buffer.append(indent + " +- " + name);
                if (isLinkRef) {
                    try {
                        this.log.trace("looking up LinkRef; name=" + name);
                        Object obj = ctx.lookupLink(name);
                        this.log.trace("Object type: " + obj.getClass());
                        LinkRef link = (LinkRef)obj;
                        buffer.append("[link -> ");
                        buffer.append(link.getLinkName());
                        buffer.append(']');
                    }
                    catch (Throwable t) {
                        this.log.debug("Invalid LinkRef for: " + name, t);
                        buffer.append("invalid]");
                    }
                }
                if (isProxy) {
                    buffer.append(" (proxy: " + pair.getClassName());
                    if (c != null) {
                        Class<?>[] ifaces = c.getInterfaces();
                        buffer.append(" implements ");
                        for (int i = 0; i < ifaces.length; ++i) {
                            buffer.append(ifaces[i]);
                            buffer.append(',');
                        }
                        buffer.setCharAt(buffer.length() - 1, ')');
                    } else {
                        buffer.append(" implements " + className + ")");
                    }
                } else if (verbose) {
                    buffer.append(" (class: " + pair.getClassName() + ")");
                }
                buffer.append('\n');
                if (!recursive) continue;
                try {
                    Object value = ctx.lookup(name);
                    if (value instanceof Context) {
                        Context subctx = (Context)value;
                        this.list(subctx, indent + " |  ", buffer, verbose);
                        continue;
                    }
                    buffer.append(indent + " |   NonContext: " + value);
                    buffer.append('\n');
                }
                catch (Throwable t) {
                    buffer.append("Failed to lookup: " + name + ", errmsg=" + t.getMessage());
                    buffer.append('\n');
                }
            }
            ne.close();
        }
        catch (NamingException ne) {
            buffer.append("error while listing context " + ctx.toString() + ": " + ne.toString(true));
            this.formatException(buffer, ne);
        }
    }

    private void listXML(Context ctx, StringBuffer buffer) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            NamingEnumeration<NameClassPair> ne = ctx.list("");
            while (ne.hasMore()) {
                NameClassPair pair = ne.next();
                boolean recursive = false;
                boolean isLinkRef = false;
                try {
                    Class<?> c = loader.loadClass(pair.getClassName());
                    if (Context.class.isAssignableFrom(c)) {
                        recursive = true;
                    }
                    if (LinkRef.class.isAssignableFrom(c)) {
                        isLinkRef = true;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                String name = pair.getName();
                if (isLinkRef) {
                    Object obj = null;
                    LinkRef link = null;
                    try {
                        obj = ctx.lookupLink(name);
                        link = (LinkRef)obj;
                    }
                    catch (Throwable t) {
                        this.log.error("Invalid LinkRef for: " + name, t);
                        this.appendLinkRefErrorTag(buffer);
                    }
                    this.appendLinkRefTag(buffer, link, pair);
                    continue;
                }
                if (recursive) {
                    Object value = null;
                    try {
                        value = ctx.lookup(name);
                    }
                    catch (Throwable t) {
                        this.appendErrorTag(buffer, "Failed to lookup: " + name + ", errmsg=" + t.getMessage());
                    }
                    if (value instanceof Context) {
                        Context subctx = (Context)value;
                        this.openContextTag(buffer);
                        this.appendNCPTag(buffer, pair);
                        try {
                            this.listXML(subctx, buffer);
                        }
                        catch (Throwable t) {
                            this.appendErrorTag(buffer, "Failed to list contents of: " + name + ", errmsg=" + t.getMessage());
                        }
                        this.closeContextTag(buffer);
                        continue;
                    }
                    this.appendNonContextTag(buffer, pair);
                    continue;
                }
                this.appendLeafTag(buffer, pair);
            }
            ne.close();
        }
        catch (NamingException ne) {
            this.appendErrorTag(buffer, "error while listing context " + ctx.toString() + ": " + ne.toString(true));
        }
    }

    private void listModuleContainers(StringBuffer buffer, ObjectName app) {
        Collection containers = null;
        try {
            containers = (Collection)this.server.getAttribute(app, "Containers");
        }
        catch (Throwable t) {
            this.log.error("getContainers failed", t);
            this.appendPreExceptionTag(buffer, "Failed to get ejbs in module", t);
        }
        Iterator iter = containers.iterator();
        while (iter.hasNext()) {
            this.listContainerContext(buffer, (Container)iter.next());
        }
    }

    private void listContainerContext(StringBuffer buffer, Container con) {
        Thread.currentThread().setContextClassLoader(con.getClassLoader());
        String bean = con.getBeanMetaData().getEjbName();
        this.openContextTag(buffer);
        this.appendBeanTag(buffer, bean);
        Context context = null;
        try {
            context = new InitialContext();
            context = (Context)context.lookup("java:comp");
        }
        catch (NamingException e) {
            this.appendErrorTag(buffer, "Failed on lookup " + e.toString(true));
            context = null;
        }
        if (context != null) {
            try {
                this.listXML(context, buffer);
            }
            catch (Throwable t) {
                this.appendErrorTag(buffer, "Failed on list contents, " + t.toString());
            }
        }
        this.closeContextTag(buffer);
    }

    private void openJndiTag(StringBuffer buffer) {
        buffer.append("<jndi>\n");
    }

    private void closeJndiTag(StringBuffer buffer) {
        buffer.append("</jndi>\n");
    }

    private void openWebModuleTag(StringBuffer buffer, String file) {
        buffer.append("<webmodule>\n");
        buffer.append("<file>").append(file).append("</file>\n");
    }

    private void closeWebModuleTag(StringBuffer buffer) {
        buffer.append("</webmodule>\n");
    }

    private void openEjbModuleTag(StringBuffer buffer, String file) {
        buffer.append("<ejbmodule>\n");
        buffer.append("<file>" + file + "</file>\n");
    }

    private void closeEjbModuleTag(StringBuffer buffer) {
        buffer.append("</ejbmodule>\n");
    }

    private void appendPreExceptionTag(StringBuffer buffer, String msg, Throwable t) {
        buffer.append("<pre>\n" + msg + "\n");
        this.formatException(buffer, t);
        buffer.append("</pre>\n");
    }

    private void appendBeanTag(StringBuffer buffer, String bean) {
        buffer.append("<name>java:comp</name>\n");
        buffer.append("<attribute name='bean'>" + bean + "</attribute>\n");
    }

    private void appendJavaNameTag(StringBuffer buffer) {
        buffer.append("<name>java:</name>\n");
    }

    private void appendGlobalNameTag(StringBuffer buffer) {
        buffer.append("<name>Global</name>\n");
    }

    private void appendHANameTag(StringBuffer buffer) {
        buffer.append("<name>HA</name>\n");
    }

    private void appendLinkRefTag(StringBuffer buffer, LinkRef link, NameClassPair ncp) {
        buffer.append("<link-ref>\n");
        buffer.append("<name>" + ncp.getName() + "</name>\n");
        try {
            String lName = link.getLinkName();
            buffer.append("<link>" + lName + "</link>\n");
        }
        catch (NamingException e) {
            this.appendErrorTag(buffer, "Failed to getLinkName, " + e.toString(true));
        }
        buffer.append("<attribute name='class'>" + ncp.getClassName() + "</attribute>\n");
        buffer.append("</link-ref>\n");
    }

    private void appendLinkRefErrorTag(StringBuffer buffer) {
        buffer.append("<link-ref>\n");
        buffer.append("<name>Invalid</name>\n");
        buffer.append("</link-ref>\n");
    }

    private void openContextTag(StringBuffer buffer) {
        buffer.append("<context>\n");
    }

    private void closeContextTag(StringBuffer buffer) {
        buffer.append("</context>\n");
    }

    private void appendNonContextTag(StringBuffer buffer, NameClassPair ncp) {
        buffer.append("<non-context>\n");
        this.appendNCPTag(buffer, ncp);
        buffer.append("</non-context>\n");
    }

    private void appendLeafTag(StringBuffer buffer, NameClassPair ncp) {
        buffer.append("<leaf>\n");
        this.appendNCPTag(buffer, ncp);
        buffer.append("</leaf>\n");
    }

    private void appendNCPTag(StringBuffer buffer, NameClassPair ncp) {
        buffer.append("<name>" + ncp.getName() + "</name>\n");
        buffer.append("<attribute name='class'>" + ncp.getClassName() + "</attribute>\n");
    }

    private void appendErrorTag(StringBuffer buffer, String msg) {
        buffer.append("<error>\n");
        buffer.append("<message>" + msg + "</message>\n");
        buffer.append("</error>\n");
    }

    private void formatException(StringBuffer buffer, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        buffer.append("<pre>\n");
        t.printStackTrace(pw);
        buffer.append(sw.toString());
        buffer.append("</pre>\n");
    }

    private String getHAUrl() {
        String bindAddress = null;
        String portNumber = null;
        AttributeList list = this.getHAJndiAttributes();
        if (list == null) {
            return null;
        }
        Object o = list.get(0);
        if (o != null) {
            bindAddress = ((Attribute)o).getValue().toString();
        }
        if ((o = list.get(1)) != null) {
            portNumber = ((Attribute)o).getValue().toString();
        }
        if (bindAddress != null && portNumber != null) {
            return "jnp://" + bindAddress + ":" + portNumber;
        }
        return null;
    }

    private AttributeList getHAJndiAttributes() {
        if (this.haNamingService == null) {
            return null;
        }
        try {
            ObjectName name = new ObjectName(this.haNamingService);
            return this.server.getAttributes(name, g_haAttributes);
        }
        catch (InstanceNotFoundException e1) {
            return null;
        }
        catch (Exception e) {
            this.log.error("JNDIView.getHAJndiAttributes() failed", e);
            return null;
        }
    }
}

