/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.MBeanElement;
import org.jboss.mx.server.ObjectInputStreamWithClassLoader;
import org.jboss.mx.util.MLetVersion;
import org.jboss.util.UnreachableStatementException;
import org.jboss.util.propertyeditor.PropertyEditors;

public class MBeanInstaller {
    public static final String VERSIONS = "versions";
    public static final String DATE = "date";
    private static final Logger log;
    private MBeanServer server;
    private ClassLoader ctxClassLoader;
    private ObjectName loaderName;
    private ObjectName registryName;

    public MBeanInstaller(MBeanServer server, ClassLoader ctxClassLoader, ObjectName loaderName) throws Exception {
        this.server = server;
        this.ctxClassLoader = ctxClassLoader;
        this.loaderName = loaderName;
        this.registryName = new ObjectName("JMImplementation:type=MBeanRegistry");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectInstance installMBean(MBeanElement element) throws MBeanException, ReflectionException, InstanceNotFoundException, MalformedObjectNameException {
        log.debug("Installing MBean: " + element);
        ObjectInstance instance = null;
        ObjectName elementName = this.getElementName(element);
        if (!element.getVersions().isEmpty()) {
            if (this.server.isRegistered(elementName)) return this.updateMBean(element);
        }
        if (element.getCode() != null) {
            return this.createMBean(element);
        }
        if (element.getObject() == null) throw new MBeanException(new IllegalArgumentException("No code or object tag"));
        return this.deserialize(element);
    }

    public ObjectInstance createMBean(MBeanElement element) throws MBeanException, ReflectionException, InstanceNotFoundException, MalformedObjectNameException {
        log.debug("Creating MBean.. ");
        ObjectName elementName = this.getElementName(element);
        Map valueMap = this.createValueMap(element);
        String[] classes = element.getConstructorTypes();
        String[] paramStrings = element.getConstructorValues();
        Object[] params = new Object[paramStrings.length];
        for (int i = 0; i < paramStrings.length; ++i) {
            try {
                Class typeClass = this.server.getClassLoaderRepository().loadClass(classes[i]);
                PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
                if (editor == null) {
                    throw new IllegalArgumentException("No property editor for type=" + typeClass);
                }
                editor.setAsText(paramStrings[i]);
                params[i] = editor.getValue();
                continue;
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        }
        Object instance = this.server.instantiate(element.getCode(), this.loaderName, params, classes);
        return this.registerMBean(instance, elementName, valueMap);
    }

    public ObjectInstance deserialize(MBeanElement element) throws MBeanException, ReflectionException, InstanceNotFoundException, MalformedObjectNameException {
        InputStream is = null;
        Object instance = null;
        try {
            is = this.ctxClassLoader.getResourceAsStream(element.getObject());
            if (is == null) {
                throw new IllegalArgumentException("Object not found " + element.getObject());
            }
            ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader(is, this.ctxClassLoader);
            instance = ois.readObject();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ignored) {}
            }
        }
        ObjectName elementName = this.getElementName(element);
        Map valueMap = this.createValueMap(element);
        return this.registerMBean(instance, elementName, valueMap);
    }

    public ObjectInstance updateMBean(MBeanElement element) throws MBeanException, ReflectionException, InstanceNotFoundException, MalformedObjectNameException {
        log.debug("updating MBean... ");
        ObjectName elementName = this.getElementName(element);
        MLetVersion preVersion = new MLetVersion(this.getVersions(elementName));
        MLetVersion newVersion = new MLetVersion(element.getVersions());
        log.debug("Installed version : " + preVersion);
        log.debug("Loaded version    : " + newVersion);
        if (!preVersion.isNull() && !newVersion.isNull() && preVersion.compareTo(newVersion) < 0) {
            if (this.server.isRegistered(elementName)) {
                this.unregisterMBean(elementName);
                log.debug("Unregistering previous version " + preVersion);
            }
            log.debug("Installing newer version " + newVersion);
            return this.createMBean(element);
        }
        return this.server.getObjectInstance(elementName);
    }

    private ObjectName getElementName(MBeanElement element) throws MalformedObjectNameException {
        return element.getName() != null ? new ObjectName(element.getName()) : null;
    }

    private Map createValueMap(MBeanElement element) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        if (element.getVersions() != null && !element.getVersions().isEmpty()) {
            valueMap.put(VERSIONS, element.getVersions());
        }
        valueMap.put(DATE, new Date(System.currentTimeMillis()));
        valueMap.put("org.jboss.mx.classloader", this.ctxClassLoader);
        return valueMap;
    }

    private List getVersions(ObjectName name) throws MBeanException, ReflectionException, InstanceNotFoundException {
        if (!this.server.isRegistered(name)) {
            return null;
        }
        return (List)this.getValue(name, VERSIONS);
    }

    private Object getValue(ObjectName name, String key) throws MBeanException, ReflectionException, InstanceNotFoundException {
        Object value = this.server.invoke(this.registryName, "getValue", new Object[]{name, key}, new String[]{ObjectName.class.getName(), String.class.getName()});
        return value;
    }

    private ObjectInstance registerMBean(Object object, ObjectName name, Map valueMap) throws MBeanException, ReflectionException, InstanceNotFoundException {
        if (object == null) {
            throw new ReflectionException(new IllegalArgumentException("Attempting to register a null object"));
        }
        return (ObjectInstance)this.server.invoke(this.registryName, "registerMBean", new Object[]{object, name, valueMap}, new String[]{Object.class.getName(), ObjectName.class.getName(), Map.class.getName()});
    }

    private void unregisterMBean(ObjectName name) throws MBeanException, ReflectionException, InstanceNotFoundException {
        this.server.invoke(this.registryName, "unregisterMBean", new Object[]{name}, new String[]{ObjectName.class.getName()});
    }

    static {
        Class c;
        log = Logger.getLogger(MBeanInstaller.class);
        Class clazz = c = PropertyEditors.class;
        if (c == null) {
            throw new UnreachableStatementException();
        }
    }
}

