/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.retrieval.cummulative;

import java.util.HashSet;
import java.util.List;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDatasItem;
import org.jboss.metadata.spi.retrieval.simple.SimpleMetaDatasItem;

public class CummulativeMetaDatasItem
extends SimpleMetaDatasItem {
    private MetaDataContext context;
    private boolean includeParent;
    private long validTime;

    public CummulativeMetaDatasItem(MetaDataContext context, boolean includeParent) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.context = context;
        this.includeParent = includeParent;
        this.init(context.getValidTime().getValidTime());
    }

    public Object[] getValue() {
        this.checkValid();
        return super.getValue();
    }

    public MetaDataItem[] getMetaDatas() {
        this.checkValid();
        return super.getMetaDatas();
    }

    public boolean isCachable() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    protected void checkValid() {
        MetaDataItem[] items = super.getMetaDatas();
        boolean valid = items != null;
        long newValidTime = this.context.getValidTime().getValidTime();
        if (this.validTime < newValidTime) {
            valid = false;
        }
        if (items != null) {
            for (MetaDataItem item : items) {
                if (item.isValid()) continue;
                valid = false;
            }
        }
        if (!valid) {
            this.init(newValidTime);
        }
    }

    protected void init(long validTime) {
        HashSet<MetaDataItem> temp = null;
        List<MetaDataRetrieval> retrievals = null;
        retrievals = this.includeParent ? this.context.getRetrievals() : this.context.getLocalRetrievals();
        for (MetaDataRetrieval retrieval : retrievals) {
            MetaDataItem[] items;
            MetaDatasItem item = retrieval.retrieveMetaData();
            if (item == null) continue;
            for (MetaDataItem it : items = item.getMetaDatas()) {
                if (temp == null) {
                    temp = new HashSet<MetaDataItem>();
                }
                temp.add(it);
            }
        }
        MetaDataItem[] items = NO_META_DATA_ITEMS;
        if (temp != null) {
            items = temp.toArray(new MetaDataItem[temp.size()]);
        }
        this.setMetaDataItems(items);
        this.validTime = validTime;
    }
}

