/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.retrieval.cummulative;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationsItem;

public class CummulativeAnnotationsItem
extends SimpleAnnotationsItem {
    private MetaDataContext context;
    private boolean includeParent;
    private long validTime;

    public CummulativeAnnotationsItem(MetaDataContext context, boolean includeParent) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.context = context;
        this.includeParent = includeParent;
        this.init(context.getValidTime().getValidTime());
    }

    public Annotation[] getValue() {
        this.checkValid();
        return super.getValue();
    }

    public AnnotationItem[] getAnnotations() {
        this.checkValid();
        return super.getAnnotations();
    }

    public boolean isCachable() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    protected void checkValid() {
        AnnotationItem[] items = super.getAnnotations();
        boolean valid = items != null;
        long newValidTime = this.context.getValidTime().getValidTime();
        if (this.validTime < newValidTime) {
            valid = false;
        }
        if (valid && items != null) {
            for (AnnotationItem item : items) {
                if (item.isValid()) continue;
                valid = false;
            }
        }
        if (!valid) {
            this.init(newValidTime);
        }
    }

    protected void init(long validTime) {
        HashSet<AnnotationItem> temp = null;
        List<MetaDataRetrieval> retrievals = null;
        retrievals = this.includeParent ? this.context.getRetrievals() : this.context.getLocalRetrievals();
        for (MetaDataRetrieval retrieval : retrievals) {
            AnnotationItem[] items;
            AnnotationsItem item = retrieval.retrieveAnnotations();
            if (item == null) continue;
            for (AnnotationItem it : items = item.getAnnotations()) {
                if (temp == null) {
                    temp = new HashSet<AnnotationItem>();
                }
                temp.add(it);
            }
        }
        AnnotationItem[] items = NO_ANNOTATION_ITEMS;
        if (temp != null) {
            items = temp.toArray(new AnnotationItem[temp.size()]);
        }
        this.setAnnotationItems(items);
        this.validTime = validTime;
    }
}

