/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.plugins.AbstractDependencyInfo;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.KernelControllerContextActions;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.repository.spi.MetaDataContext;
import org.jboss.util.JBossStringBuilder;

public class AbstractKernelControllerContext
extends AbstractControllerContext
implements KernelControllerContext {
    private static final KernelControllerContextActions actions = KernelControllerContextActions.getInstance();
    private static final KernelControllerContextActions noInstantiate = KernelControllerContextActions.getNoInstantiate();
    protected BeanInfo info;
    protected BeanMetaData metaData;
    protected AccessControlContext accessContext;

    public AbstractKernelControllerContext(BeanInfo info, BeanMetaData metaData, Object target) {
        super(metaData.getName(), target == null ? actions : noInstantiate, new AbstractDependencyInfo(), target);
        this.info = info;
        this.metaData = metaData;
        ControllerMode mode = metaData.getMode();
        if (mode != null) {
            this.setMode(mode);
        }
        if (System.getSecurityManager() != null) {
            this.accessContext = AccessController.getContext();
        }
    }

    public Kernel getKernel() {
        KernelController controller = (KernelController)this.getController();
        if (controller == null) {
            throw new IllegalStateException("Context is not installed in controller");
        }
        return controller.getKernel();
    }

    public BeanInfo getBeanInfo() {
        return this.info;
    }

    public void setBeanInfo(BeanInfo info) {
        this.info = info;
        this.flushJBossObjectCache();
    }

    public BeanMetaData getBeanMetaData() {
        return this.metaData;
    }

    public void toString(JBossStringBuilder buffer) {
        if (this.metaData != null) {
            buffer.append(" metadata=").append(this.metaData);
        }
        super.toString(buffer);
    }

    public void setController(Controller controller) {
        super.setController(controller);
        this.preprocessMetaData();
    }

    protected void preprocessMetaData() {
        if (this.metaData == null) {
            return;
        }
        PreprocessMetaDataVisitor visitor = new PreprocessMetaDataVisitor(this.metaData);
        AccessController.doPrivileged(visitor);
    }

    public MetaDataContext getMetaDataContext() {
        if (this.info != null) {
            return this.info.getMetaDataContext();
        }
        return null;
    }

    public void setMetaDataContext(MetaDataContext mctx) {
        this.info = this.info.getInstanceInfo();
        this.info.setMetaDataContext(mctx);
    }

    protected AccessControlContext getAccessControlContext() {
        return this.accessContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PreprocessMetaDataVisitor
    implements MetaDataVisitor,
    PrivilegedAction<Object> {
        private ControllerState contextState = ControllerState.INSTANTIATED;
        private BeanMetaData bmd;

        public PreprocessMetaDataVisitor(BeanMetaData bmd) {
            this.bmd = bmd;
        }

        @Override
        public Object run() {
            this.bmd.visit(this);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visit(MetaDataVisitorNode node) {
            Iterator<? extends MetaDataVisitorNode> children;
            boolean trace = AbstractKernelControllerContext.this.log.isTraceEnabled();
            if (trace) {
                AbstractKernelControllerContext.this.log.trace("Visit node " + node);
            }
            if ((children = node.getChildren()) != null) {
                ControllerState restoreState = this.contextState;
                while (children.hasNext()) {
                    MetaDataVisitorNode child = children.next();
                    try {
                        child.visit(this);
                    }
                    finally {
                        this.contextState = restoreState;
                    }
                }
            }
        }

        @Override
        public KernelControllerContext getControllerContext() {
            return AbstractKernelControllerContext.this;
        }

        @Override
        public ControllerState getContextState() {
            return this.contextState;
        }

        @Override
        public void addDependency(DependencyItem dependency) {
            AbstractKernelControllerContext.this.getDependencyInfo().addIDependOn(dependency);
        }

        @Override
        public void setContextState(ControllerState contextState) {
            this.contextState = contextState;
        }
    }
}

