/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.asf;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.jms.XASession;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jms.asf.StdServerSessionPool;
import org.jboss.jms.asf.StdServerSessionPoolFactory;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionManagerService;
import org.jboss.tm.XidFactoryMBean;

public class StdServerSession
implements Runnable,
ServerSession,
MessageListener {
    static Logger log = Logger.getLogger(StdServerSession.class);
    private StdServerSessionPool serverSessionPool;
    private Session session;
    private XASession xaSession;
    private TransactionManager tm;
    private boolean useLocalTX;
    private MessageListener delegateListener;
    private XidFactoryMBean xidFactory;

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.tm = transactionManager;
    }

    StdServerSession(StdServerSessionPool pool, Session session, XASession xaSession, MessageListener delegateListener, boolean useLocalTX, XidFactoryMBean xidFactory, TransactionManager tm) throws JMSException {
        this.serverSessionPool = pool;
        this.session = session;
        this.xaSession = xaSession;
        this.delegateListener = delegateListener;
        if (xaSession == null) {
            useLocalTX = false;
        }
        this.useLocalTX = useLocalTX;
        this.xidFactory = xidFactory;
        this.tm = tm;
        log.trace(this + " initializing (pool, session, xaSession, useLocalTX): " + pool + ", " + session + ", " + xaSession + ", " + useLocalTX);
        if (StdServerSessionPoolFactory.USE_OLD && xaSession != null) {
            xaSession.setMessageListener(this);
        } else {
            session.setMessageListener(this);
        }
        if (tm == null) {
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                this.tm = (TransactionManager)ctx.lookup(TransactionManagerService.JNDI_NAME);
            }
            catch (Exception e) {
                throw new JMSException("Transation manager was not found");
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
    }

    public Session getSession() throws JMSException {
        if (StdServerSessionPoolFactory.USE_OLD && this.xaSession != null) {
            return this.xaSession;
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean trace = log.isTraceEnabled();
        TransactionDemarcation td = null;
        if (!StdServerSessionPoolFactory.USE_OLD && (td = this.createTransactionDemarcation()) == null) {
            return;
        }
        try {
            if (trace) {
                log.trace(this + " running...");
            }
            if (StdServerSessionPoolFactory.USE_OLD && this.xaSession != null) {
                this.xaSession.run();
            } else {
                this.session.run();
            }
            if (trace) {
                log.trace(this + " run.");
            }
        }
        catch (Throwable t) {
            log.error(this + " onMessage failed to run; setting rollback only", t);
            if (td != null) {
                td.error();
            }
        }
        finally {
            if (td != null) {
                td.end();
            }
            this.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        boolean trace = log.isTraceEnabled();
        TransactionDemarcation td = null;
        if (StdServerSessionPoolFactory.USE_OLD && (td = this.createTransactionDemarcation()) == null) {
            return;
        }
        try {
            if (trace) {
                log.trace(this + " onMessage running (pool, session, xaSession, useLocalTX): " + ", " + this.session + ", " + this.xaSession + ", " + this.useLocalTX);
            }
            this.delegateListener.onMessage(msg);
            if (trace) {
                log.trace(this + " onMessage finished");
            }
        }
        catch (Throwable t) {
            log.error(this + " onMessage failed to run; setting rollback only", t);
            if (td != null) {
                td.error();
            }
        }
        finally {
            if (td != null) {
                td.end();
            }
        }
        if (trace) {
            log.trace(this + " onMessage done");
        }
    }

    public void start() throws JMSException {
        log.trace(this + " starting invokes on server session");
        if (this.session != null) {
            try {
                this.serverSessionPool.getExecutor().execute((Runnable)this);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            throw new JMSException(this + " no listener has been specified");
        }
    }

    void close() {
        log.trace(this + " closing.");
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            this.session = null;
        }
        if (this.xaSession != null) {
            try {
                this.xaSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.xaSession = null;
        }
        log.debug("closed");
    }

    void recycle() {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace(this + " recycling");
        }
        this.serverSessionPool.recycle(this);
        if (trace) {
            log.trace(this + " recycled");
        }
    }

    TransactionDemarcation createTransactionDemarcation() {
        try {
            return new TransactionDemarcation();
        }
        catch (Throwable t) {
            log.error(this + " error creating transaction demarcation ", t);
            return null;
        }
    }

    private class TransactionDemarcation {
        boolean trace = log.isTraceEnabled();
        Xid localXid = null;
        boolean localRollbackFlag = false;
        Transaction trans = null;

        public TransactionDemarcation() throws Throwable {
            if (StdServerSession.this.useLocalTX) {
                this.localXid = StdServerSession.this.xidFactory.newXid();
                XAResource res = StdServerSession.this.xaSession.getXAResource();
                res.start(this.localXid, 0);
                if (this.trace) {
                    log.trace(StdServerSession.this + " using optimized 1p commit to control TX. xid=" + this.localXid);
                }
            } else {
                StdServerSession.this.tm.begin();
                try {
                    this.trans = StdServerSession.this.tm.getTransaction();
                    if (this.trace) {
                        log.trace(StdServerSession.this + " using tx=" + this.trans);
                    }
                    if (StdServerSession.this.xaSession != null) {
                        XAResource res = StdServerSession.this.xaSession.getXAResource();
                        if (!this.trans.enlistResource(res)) {
                            throw new JMSException("could not enlist resource");
                        }
                        if (this.trace) {
                            log.trace(StdServerSession.this + " XAResource '" + res + "' enlisted.");
                        }
                    }
                }
                catch (Throwable t) {
                    try {
                        StdServerSession.this.tm.rollback();
                    }
                    catch (Throwable ignored) {
                        log.trace(StdServerSession.this + " ignored error rolling back after failed enlist", ignored);
                    }
                    throw t;
                }
            }
        }

        public void error() {
            if (StdServerSession.this.useLocalTX) {
                this.localRollbackFlag = true;
            } else {
                try {
                    if (this.trace) {
                        log.trace(StdServerSession.this + " using TM to mark TX for rollback tx=" + this.trans);
                    }
                    this.trans.setRollbackOnly();
                }
                catch (Throwable t) {
                    log.error(StdServerSession.this + " failed to set rollback only", t);
                }
            }
        }

        public void end() {
            try {
                if (StdServerSession.this.useLocalTX) {
                    if (this.localRollbackFlag) {
                        if (this.trace) {
                            log.trace(StdServerSession.this + " using optimized 1p commit to rollback TX xid=" + this.localXid);
                        }
                        XAResource res = StdServerSession.this.xaSession.getXAResource();
                        res.end(this.localXid, 0x4000000);
                        res.rollback(this.localXid);
                    } else {
                        if (this.trace) {
                            log.trace(StdServerSession.this + " using optimized 1p commit to commit TX xid=" + this.localXid);
                        }
                        XAResource res = StdServerSession.this.xaSession.getXAResource();
                        res.end(this.localXid, 0x4000000);
                        res.commit(this.localXid, true);
                    }
                } else {
                    Transaction currentTx = StdServerSession.this.tm.getTransaction();
                    if (!this.trans.equals(currentTx)) {
                        throw new IllegalStateException("Wrong tx association: expected " + this.trans + " was " + currentTx);
                    }
                    if (this.trans.getStatus() == 1) {
                        if (this.trace) {
                            log.trace(StdServerSession.this + " rolling back JMS transaction tx=" + this.trans);
                        }
                        StdServerSession.this.tm.rollback();
                        if (StdServerSession.this.xaSession == null && StdServerSession.this.serverSessionPool.isTransacted()) {
                            StdServerSession.this.session.rollback();
                        }
                    } else if (this.trans.getStatus() == 0) {
                        if (this.trace) {
                            log.trace(StdServerSession.this + " commiting the JMS transaction tx=" + this.trans);
                        }
                        StdServerSession.this.tm.commit();
                        if (StdServerSession.this.xaSession == null && StdServerSession.this.serverSessionPool.isTransacted()) {
                            StdServerSession.this.session.commit();
                        }
                    }
                }
            }
            catch (Throwable t) {
                log.error(StdServerSession.this + " failed to commit/rollback", t);
            }
        }
    }
}

