/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import java.io.Serializable;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;

public class TimedObjectId
implements Serializable {
    private ObjectName containerId;
    private Object instancePk;
    private int hashCode;

    public TimedObjectId(ObjectName containerId, Object instancePk) {
        if (containerId == null) {
            throw new IllegalArgumentException("containerId cannot be null");
        }
        this.containerId = containerId;
        this.instancePk = instancePk;
    }

    public TimedObjectId(ObjectName timedObjectId) {
        this(timedObjectId, null);
    }

    public ObjectName getContainerId() {
        return this.containerId;
    }

    public Object getInstancePk() {
        return this.instancePk;
    }

    public static TimedObjectId parse(String externalForm) {
        if (!externalForm.startsWith("[") || !externalForm.endsWith("]")) {
            throw new IllegalArgumentException("Square brackets expected arround: " + externalForm);
        }
        String inStr = externalForm.substring(1, externalForm.length() - 1);
        if (!inStr.startsWith("target=")) {
            throw new IllegalArgumentException("Cannot parse: " + externalForm);
        }
        String jmxStr = inStr.substring(7);
        String pkStr = null;
        int pkIndex = jmxStr.indexOf(",pk=");
        if (pkIndex > 0) {
            pkStr = jmxStr.substring(pkIndex + 4);
            jmxStr = jmxStr.substring(0, pkIndex);
        }
        ObjectName contatinerId = ObjectNameFactory.create(jmxStr);
        return new TimedObjectId(contatinerId, pkStr);
    }

    public String toExternalForm() {
        String pkStr = this.instancePk != null ? ",pk=" + this.instancePk : "";
        return "[target=" + this.containerId + pkStr + "]";
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TimedObjectId) {
            TimedObjectId other = (TimedObjectId)obj;
            if (this.containerId.equals(other.containerId)) {
                return this.instancePk != null ? this.instancePk.equals(other.instancePk) : other.instancePk == null;
            }
        }
        return false;
    }

    public String toString() {
        return this.toExternalForm();
    }
}

