/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.config.plugins;

import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.classadapter.spi.ClassAdapterFactory;
import org.jboss.classadapter.spi.DependencyBuilder;
import org.jboss.config.spi.Configuration;
import org.jboss.joinpoint.spi.JoinpointFactoryBuilder;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.repository.spi.MetaDataContextFactory;
import org.jboss.util.NestedRuntimeException;

public abstract class AbstractConfiguration
implements Configuration {
    private BeanInfoFactory beanInfoFactory;
    private ClassAdapterFactory classAdapterFactory;
    private TypeInfoFactory typeInfoFactory;
    private JoinpointFactoryBuilder joinpointFactoryBuilder;
    private MetaDataContextFactory metaDataContextFactory;
    private DependencyBuilder dependencyBuilder;

    public BeanInfo getBeanInfo(String className, ClassLoader cl) throws Throwable {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(className, cl);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter);
    }

    public BeanInfo getBeanInfo(Class clazz) throws Throwable {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(clazz);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter);
    }

    public BeanInfo getBeanInfo(TypeInfo typeInfo) throws Throwable {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(typeInfo);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter);
    }

    public ClassInfo getClassInfo(String className, ClassLoader cl) throws Throwable {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(className, cl);
        return classAdapter.getClassInfo();
    }

    public ClassInfo getClassInfo(Class clazz) throws Throwable {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(clazz);
        return classAdapter.getClassInfo();
    }

    public TypeInfoFactory getTypeInfoFactory() {
        if (this.typeInfoFactory == null) {
            try {
                this.typeInfoFactory = this.createDefaultTypeInfoFactory();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("Cannot create TypeInfoFactory", t);
            }
        }
        return this.typeInfoFactory;
    }

    public JoinpointFactoryBuilder getJoinpointFactoryBuilder() {
        if (this.joinpointFactoryBuilder == null) {
            try {
                this.joinpointFactoryBuilder = this.createDefaultJoinpointFactoryBuilder();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("Cannot create JoinpointFactoryBuilder", t);
            }
        }
        return this.joinpointFactoryBuilder;
    }

    public MetaDataContextFactory getMetaDataContextFactory() {
        if (this.metaDataContextFactory == null) {
            try {
                this.metaDataContextFactory = this.createDefaultMetaDataContextFactory();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("Cannot create MetaDataContextFactory", t);
            }
        }
        return this.metaDataContextFactory;
    }

    public DependencyBuilder getDependencyBuilder() {
        if (this.dependencyBuilder == null) {
            try {
                this.dependencyBuilder = this.createDefaultDependencyBuilder();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("Cannot create DependencyBuilder", t);
            }
        }
        return this.dependencyBuilder;
    }

    protected BeanInfoFactory getBeanInfoFactory() throws Throwable {
        if (this.beanInfoFactory == null) {
            this.beanInfoFactory = this.createDefaultBeanInfoFactory();
        }
        return this.beanInfoFactory;
    }

    protected ClassAdapterFactory getClassAdapterFactory() throws Throwable {
        if (this.classAdapterFactory == null) {
            this.classAdapterFactory = this.createDefaultClassAdapterFactory();
        }
        return this.classAdapterFactory;
    }

    protected abstract BeanInfoFactory createDefaultBeanInfoFactory() throws Throwable;

    protected abstract ClassAdapterFactory createDefaultClassAdapterFactory() throws Throwable;

    protected abstract TypeInfoFactory createDefaultTypeInfoFactory() throws Throwable;

    protected abstract JoinpointFactoryBuilder createDefaultJoinpointFactoryBuilder() throws Throwable;

    protected abstract MetaDataContextFactory createDefaultMetaDataContextFactory() throws Throwable;

    protected abstract DependencyBuilder createDefaultDependencyBuilder() throws Throwable;
}

