/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.joinpoint;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.metadata.MetaDataResolver;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.metadata.ThreadMetaData;

public abstract class InvocationBase
implements Serializable,
Invocation {
    static final long serialVersionUID = -4880246394729260729L;
    protected SimpleMetaData metadata = null;
    protected transient int currentInterceptor = 0;
    protected transient Interceptor[] interceptors = null;
    protected transient Advisor advisor = null;
    protected transient Map responseContextInfo = null;
    protected transient Object targetObject = null;
    protected transient MetaDataResolver instanceResolver;

    public Map getResponseContextInfo() {
        return this.responseContextInfo;
    }

    public void setResponseContextInfo(Map responseContextInfo) {
        this.responseContextInfo = responseContextInfo;
    }

    public void addResponseAttachment(Object key, Object val) {
        if (this.responseContextInfo == null) {
            this.responseContextInfo = new HashMap(1);
        }
        this.responseContextInfo.put(key, val);
    }

    public Object getResponseAttachment(Object key) {
        if (this.responseContextInfo == null) {
            return null;
        }
        return this.responseContextInfo.get(key);
    }

    public SimpleMetaData getMetaData() {
        if (this.metadata == null) {
            this.metadata = new SimpleMetaData();
        }
        return this.metadata;
    }

    public void setMetaData(SimpleMetaData data) {
        this.metadata = data;
    }

    public Object resolveClassMetaData(Object key, Object attr) {
        return this.getAdvisor().getClassMetaData().getMetaData(key, attr);
    }

    public int getCurrentInterceptor() {
        return this.currentInterceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNext() throws Throwable {
        try {
            Object object = this.interceptors[this.currentInterceptor++].invoke(this);
            return object;
        }
        finally {
            --this.currentInterceptor;
        }
    }

    public Object invokeTarget() throws Throwable {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNext(Interceptor[] newInterceptors) throws Throwable {
        Interceptor[] oldInterceptors = this.interceptors;
        int oldCurrentInterceptor = this.currentInterceptor;
        this.interceptors = newInterceptors;
        this.currentInterceptor = 0;
        try {
            Object object = this.invokeNext();
            return object;
        }
        finally {
            this.interceptors = oldInterceptors;
            this.currentInterceptor = oldCurrentInterceptor;
        }
    }

    public InvocationBase(Interceptor[] interceptors) {
        this(interceptors, null);
    }

    public InvocationBase(Interceptor[] interceptors, SimpleMetaData meta) {
        this.interceptors = interceptors;
        this.metadata = meta;
    }

    public InvocationBase(Invocation invocation) {
        this.interceptors = invocation.getInterceptors();
        this.setTargetObject(invocation.getTargetObject());
    }

    public InvocationBase() {
    }

    public Interceptor[] getInterceptors() {
        return this.interceptors;
    }

    public Object resolveClassAnnotation(Class annotation) {
        if (this.advisor != null) {
            return this.advisor.resolveAnnotation(annotation);
        }
        return null;
    }

    public Object resolveAnnotation(Class annotation) {
        return null;
    }

    public Object resolveAnnotation(Class[] annotations) {
        return null;
    }

    public Object getMetaData(Object group, Object attr) {
        Object val = null;
        if (this.metadata != null && (val = this.metadata.resolve(this, group, attr)) != null) {
            return val;
        }
        val = ThreadMetaData.instance().resolve(this, group, attr);
        if (val != null) {
            return val;
        }
        MetaDataResolver resolver = this.getInstanceResolver();
        if (resolver != null && (val = this.getInstanceResolver().resolve(this, group, attr)) != null) {
            return val;
        }
        return null;
    }

    public MetaDataResolver getInstanceResolver() {
        InstanceAdvisor ia;
        if (this.instanceResolver != null) {
            return this.instanceResolver;
        }
        if (this.getTargetObject() != null && this.getTargetObject() instanceof InstanceAdvised && (ia = ((InstanceAdvised)this.getTargetObject())._getInstanceAdvisor()) != null) {
            this.instanceResolver = ia.getMetaData();
            return this.instanceResolver;
        }
        return null;
    }

    public Advisor getAdvisor() {
        return this.advisor;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
    }

    public void setAdvisor(Advisor advisor) {
        this.advisor = advisor;
    }

    public void setInstanceResolver(MetaDataResolver instanceResolver) {
        this.instanceResolver = instanceResolver;
    }
}

