/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;

public class OptimizedConstructionInvocations
extends OptimizedBehaviourInvocations {
    protected static void addCopy(ClassPool pool, CtClass invocation, CtClass[] params) throws Exception {
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.ConstructionInvocation");
        CtMethod template = methodInvocation.getDeclaredMethod("copy");
        String code = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.interceptors, this.constructor); " + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; ";
        for (int i = 0; i < params.length; ++i) {
            code = code + "   wrapper.arg" + i + " = this.arg" + i + "; ";
        }
        code = code + "   return wrapper; }";
        CtMethod copy = CtNewMethod.make((CtClass)template.getReturnType(), (String)"copy", (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (String)code, (CtClass)invocation);
        copy.setModifiers(template.getModifiers());
        invocation.addMethod(copy);
    }

    protected static String getOptimizedInvocationClassName(CtClass declaringClazz, int constructorIndex) {
        return declaringClazz.getName() + constructorIndex + "OptimizedConstructionInvocation";
    }

    protected static String createOptimizedInvocationClass(Instrumentor instrumentor, CtClass clazz, CtConstructor con, int index) throws Exception {
        AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
        CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructionInvocation");
        CtClass untransformable = pool.get("org.jboss.aop.instrument.Untransformable");
        String className = OptimizedConstructionInvocations.getOptimizedInvocationClassName(clazz, index);
        boolean makeInnerClass = !Modifier.isPublic((int)con.getModifiers());
        CtClass invocation = OptimizedConstructionInvocations.makeInvocationClassNoCtors(pool, makeInnerClass, clazz, className, conInvocation);
        CtConstructor template = null;
        CtConstructor[] tcons = conInvocation.getDeclaredConstructors();
        for (int i = 0; i < tcons.length; ++i) {
            if (tcons[i].getParameterTypes().length != 2) continue;
            template = tcons[i];
            break;
        }
        CtConstructor icon = CtNewConstructor.make((CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (CtClass)invocation);
        invocation.addConstructor(icon);
        CtClass[] params = con.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            CtField field = new CtField(params[i], "arg" + i, invocation);
            field.setModifiers(1);
            invocation.addField(field);
        }
        OptimizedConstructionInvocations.addGetArguments((ClassPool)pool, invocation, con.getParameterTypes());
        OptimizedConstructionInvocations.addCopy((ClassPool)pool, invocation, con.getParameterTypes());
        TransformerCommon.compileOrLoadClass(con.getDeclaringClass(), invocation);
        return invocation.getName();
    }
}

