/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.util.ArrayList;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aop.pointcut.PointcutMethodMatch;

class MethodMatchInfo {
    Advisor advisor;
    MethodInfo info;
    ArrayList bindings;
    ArrayList pointcutMethodMatches;

    MethodMatchInfo(Advisor advisor, MethodInfo info) {
        this.advisor = advisor;
        this.info = info;
    }

    public void addMatchedBinding(AdviceBinding binding, PointcutMethodMatch pointcutMethodMatch) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        if (this.pointcutMethodMatches == null) {
            this.pointcutMethodMatches = new ArrayList();
        }
        this.bindings.add(binding);
        this.pointcutMethodMatches.add(pointcutMethodMatch);
    }

    public MethodInfo getInfo() {
        return this.info;
    }

    public void setInfo(MethodInfo info) {
        this.info = info;
    }

    public ArrayList populateBindings() {
        if (this.bindings != null) {
            ArrayList applicableBindings = new ArrayList();
            if (this.advisor.chainOverridingForInheritedMethods()) {
                this.overridePopulateBindings(applicableBindings);
            } else {
                this.simplePopulateBindings(applicableBindings);
            }
            if (applicableBindings.size() > 0) {
                return applicableBindings;
            }
        }
        return null;
    }

    private void simplePopulateBindings(ArrayList applicableBindings) {
        int size = this.bindings.size();
        for (int i = 0; i < size; ++i) {
            AdviceBinding binding = (AdviceBinding)this.bindings.get(i);
            this.applyBinding(applicableBindings, binding);
        }
    }

    private void overridePopulateBindings(ArrayList applicableBindings) {
        PointcutMethodMatch match;
        AdviceBinding binding;
        int i;
        if (AspectManager.verbose) {
            System.out.println("[debug] populate bindings for " + this.info.getAdvisedMethod() + " all bindings");
        }
        int size = this.bindings.size();
        int minMatchLevel = 1000000;
        for (i = 0; i < size; ++i) {
            binding = (AdviceBinding)this.bindings.get(i);
            match = (PointcutMethodMatch)this.pointcutMethodMatches.get(i);
            if (AspectManager.verbose) {
                System.out.println("[debug] " + match.getMatchLevel() + " " + match.getMatchedClass().getName() + " " + binding.getPointcut().getExpr() + " : " + binding.getInterceptorFactories().length);
            }
            if (minMatchLevel <= match.getMatchLevel() || match.isInstanceOf()) continue;
            minMatchLevel = match.getMatchLevel();
        }
        if (AspectManager.verbose) {
            System.out.println("[debug] populate bindings for " + this.info.getAdvisedMethod() + " actual bindings");
        }
        for (i = 0; i < size; ++i) {
            binding = (AdviceBinding)this.bindings.get(i);
            match = (PointcutMethodMatch)this.pointcutMethodMatches.get(i);
            if (!match.isInstanceOf() && match.getMatchLevel() != minMatchLevel) continue;
            if (AspectManager.verbose) {
                System.out.println("[debug] " + match.getMatchLevel() + " " + match.getMatchedClass().getName() + " " + binding.getPointcut().getExpr() + " : " + binding.getInterceptorFactories().length);
            }
            this.applyBinding(applicableBindings, binding);
        }
    }

    private void applyBinding(ArrayList applicableBindings, AdviceBinding binding) {
        applicableBindings.add(binding);
        binding.addAdvisor(this.advisor);
        this.advisor.pointcutResolved(this.info, binding, new MethodJoinpoint(this.info.getAdvisedMethod()));
    }

    public void clear() {
        this.bindings = null;
        this.pointcutMethodMatches = null;
        this.info.clear();
    }
}

