/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.testng.xml.TestNGContentHandler;
import org.testng.xml.XmlSuite;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    public static final String TESTNG_DTD = "testng-1.0.dtd";
    public static final String DEPRECATED_TESTNG_DTD_URL = "http://beust.com/testng/testng-1.0.dtd";
    public static final String TESTNG_DTD_URL = "http://testng.org/testng-1.0.dtd";
    public static final String DEFAULT_FILENAME = "testng.xml";
    private final String m_fileName;
    private final InputStream m_inputStream;
    private boolean m_lookInJar = false;

    private Parser(String filename, InputStream inputStream) {
        this.m_fileName = filename;
        this.m_inputStream = inputStream;
    }

    public Parser(String fileName) throws FileNotFoundException {
        this(fileName, new FileInputStream(new File(fileName)));
    }

    public Parser(InputStream inputStream) {
        this(null, inputStream);
    }

    public Parser() throws FileNotFoundException {
        this(DEFAULT_FILENAME, Parser.getDefault());
    }

    private static InputStream getDefault() throws FileNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream in = classLoader != null ? classLoader.getResourceAsStream(DEFAULT_FILENAME) : Parser.class.getResourceAsStream(DEFAULT_FILENAME);
        if (in == null) {
            throw new FileNotFoundException("Default property file of testng.xml was not found");
        }
        return in;
    }

    public Collection<XmlSuite> parse() throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, XmlSuite> mapResult = new HashMap<String, XmlSuite>();
        SAXParserFactory spf = null;
        try {
            spf = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError ex) {
            try {
                Class<?> cl = Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                spf = (SAXParserFactory)cl.newInstance();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        spf.setValidating(true);
        SAXParser saxParser = spf.newSAXParser();
        String mainFilePath = new File(this.m_fileName).getCanonicalPath();
        ArrayList<String> toBeParsed = new ArrayList<String>();
        ArrayList<String> toBeAdded = new ArrayList<String>();
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        toBeParsed.add(mainFilePath);
        while (toBeParsed.size() > 0) {
            for (String currentFile : toBeParsed) {
                String canonicalPath = new File(currentFile).getCanonicalPath();
                XmlSuite currentXmlSuite = this.parseOneFile(saxParser, canonicalPath);
                mapResult.put(canonicalPath, currentXmlSuite);
                toBeRemoved.add(canonicalPath);
                List<String> suiteFiles = currentXmlSuite.getSuiteFiles();
                if (suiteFiles.size() <= 0) continue;
                for (String path : suiteFiles) {
                    canonicalPath = new File(path).getCanonicalPath();
                    if (mapResult.containsKey(canonicalPath)) continue;
                    toBeAdded.add(canonicalPath);
                }
            }
            for (String s : toBeRemoved) {
                toBeParsed.remove(s);
            }
            toBeRemoved = new ArrayList();
            for (String s : toBeAdded) {
                toBeParsed.add(s);
            }
            toBeAdded = new ArrayList();
        }
        return mapResult.values();
    }

    private XmlSuite parseOneFile(SAXParser saxParser, String fileName) throws ParserConfigurationException, SAXException, IOException {
        TestNGContentHandler ch = new TestNGContentHandler(fileName);
        FileInputStream inputStream = new FileInputStream(fileName);
        saxParser.parse((InputStream)inputStream, (DefaultHandler)ch);
        ((InputStream)inputStream).close();
        XmlSuite result = ch.getSuite();
        return result;
    }
}

