/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.util.Iterator;
import java.util.List;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.internal.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextReporter
extends TestListenerAdapter {
    private int m_verbose = 0;
    private String m_testName = null;

    public TextReporter(String testName, int verbose) {
        this.m_testName = testName;
        this.m_verbose = verbose;
    }

    @Override
    public void onFinish(ITestContext context) {
        if (this.m_verbose >= 2) {
            this.logResults();
        }
    }

    private ITestNGMethod[] resultsToMethods(List<ITestResult> results) {
        ITestNGMethod[] result = new ITestNGMethod[results.size()];
        int i = 0;
        for (ITestResult tr : results) {
            result[i++] = tr.getMethod();
        }
        return result;
    }

    private void logResults() {
        ITestResult tr;
        ITestResult o;
        Iterator<ITestResult> i$ = this.getPassedTests().iterator();
        while (i$.hasNext()) {
            tr = o = i$.next();
            this.logResult("PASSED", tr.getName(), tr.getMethod().getDescription(), null, tr.getParameters(), tr.getMethod().getMethod().getParameterTypes());
        }
        i$ = this.getFailedTests().iterator();
        while (i$.hasNext()) {
            tr = o = i$.next();
            Throwable ex = tr.getThrowable();
            String stackTrace = "";
            if (ex != null && this.m_verbose >= 2) {
                stackTrace = Utils.stackTrace(ex, false)[0];
            }
            this.logResult("FAILED", tr.getName(), tr.getMethod().getDescription(), stackTrace, tr.getParameters(), tr.getMethod().getMethod().getParameterTypes());
        }
        i$ = this.getSkippedTests().iterator();
        while (i$.hasNext()) {
            tr = o = i$.next();
            this.logResult("SKIPPED", tr.getName(), tr.getMethod().getDescription(), null, tr.getParameters(), tr.getMethod().getMethod().getParameterTypes());
        }
        ITestNGMethod[] ft = this.resultsToMethods(this.getFailedTests());
        String stats = "\n===============================================\n    " + this.m_testName + "\n" + "    Tests run: " + Utils.calculateInvokedMethodCount(this.getAllTestMethods()) + ", Failures: " + Utils.calculateInvokedMethodCount(ft) + ", Skips: " + Utils.calculateInvokedMethodCount(this.resultsToMethods(this.getSkippedTests())) + "\n===============================================\n";
        this.logResult("", stats);
    }

    private String getName() {
        return this.m_testName;
    }

    private void logResult(String status, String message) {
        StringBuffer buf = new StringBuffer();
        if (!"".equals(status)) {
            buf.append(status).append(": ");
        }
        buf.append(message);
        System.out.println(buf);
    }

    private void logResult(String status, String name, String description, String stackTrace, Object[] params, Class[] paramTypes) {
        int i;
        StringBuffer msg = new StringBuffer(name);
        if (null != params && params.length > 0) {
            msg.append("(");
            if (params.length != paramTypes.length) {
                msg.append(name + ": Wrong number of arguments were passed by " + "the Data Provider: found " + params.length + " but " + "expected " + paramTypes.length + ")");
            } else {
                for (i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        msg.append(", ");
                    }
                    msg.append(Utils.toString(params[i], paramTypes[i]));
                }
                msg.append(")");
            }
        }
        if (!Utils.isStringEmpty(description)) {
            msg.append("\n");
            for (i = 0; i < status.length() + 2; ++i) {
                msg.append(" ");
            }
            msg.append(description);
        }
        if (!Utils.isStringEmpty(stackTrace)) {
            msg.append("\n").append(stackTrace);
        }
        this.logResult(status, msg.toString());
    }

    public void ppp(String s) {
        System.out.println("[TextReporter " + this.getName() + "] " + s);
    }
}

