/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.internal.ClassHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IConfiguration;
import org.testng.internal.annotations.IDataProvider;
import org.testng.internal.annotations.IFactory;
import org.testng.internal.annotations.IParameterizable;
import org.testng.internal.annotations.IParameters;
import org.testng.internal.annotations.ITest;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters {
    private static final String NULL_VALUE = "null";

    public static Object[] createParameters(Constructor ctor, String methodAnnotation, String[] parameterNames, Map<String, String> params, XmlSuite xmlSuite) {
        return Parameters.createParameters(ctor.toString(), ctor.getParameterTypes(), methodAnnotation, parameterNames, new MethodParameters(params), xmlSuite);
    }

    public static Object[] createTestParameters(Method m, Map<String, String> params, IAnnotationFinder finder, XmlSuite xmlSuite) {
        return Parameters.createParameters(m, new MethodParameters(params), finder, xmlSuite, ITest.class, "@Test");
    }

    public static Object[] createConfigurationParameters(Method m, Map<String, String> params, ITestNGMethod currentTestMethod, IAnnotationFinder finder, XmlSuite xmlSuite) {
        Method currentTestMeth = currentTestMethod != null ? currentTestMethod.getMethod() : null;
        return Parameters.createParameters(m, new MethodParameters(params, currentTestMeth), finder, xmlSuite, IConfiguration.class, "@Configuration");
    }

    public static Object[] createFactoryParameters(Method m, Map<String, String> params, IAnnotationFinder finder, XmlSuite xmlSuite) {
        return Parameters.createParameters(m, new MethodParameters(params), finder, xmlSuite, IFactory.class, "@Factory");
    }

    private static Object[] createParameters(String methodName, Class[] parameterTypes, String methodAnnotation, String[] parameterNames, MethodParameters params, XmlSuite xmlSuite) {
        Object[] result = new Object[]{};
        if (parameterTypes.length > 0) {
            ArrayList<Object> vResult = new ArrayList<Object>();
            if (parameterNames.length != parameterTypes.length && parameterTypes.length != parameterNames.length + 1) {
                throw new TestNGException("Method " + methodName + " needs " + parameterTypes.length + " parameters but " + parameterNames.length + " were supplied in the " + methodAnnotation + " annotation.");
            }
            int j = 0;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (Method.class.equals((Object)parameterTypes[i])) {
                    vResult.add(params.m_currentTestMethod);
                    continue;
                }
                String p = parameterNames[j];
                String value = (String)params.m_parameters.get(p);
                if (null == value) {
                    throw new TestNGException("Parameter '" + p + "' is required by " + methodAnnotation + " on method " + methodName + "\nbut has not been defined in " + xmlSuite.getFileName());
                }
                vResult.add(Parameters.convertType(parameterTypes[i], value, p));
                ++j;
            }
            result = vResult.toArray(new Object[vResult.size()]);
        }
        return result;
    }

    private static Object convertType(Class type, String value, String paramName) {
        Object result = null;
        if (NULL_VALUE.equals(value.toLowerCase())) {
            if (type.isPrimitive()) {
                Utils.log("Parameters", 2, "Attempt to pass null value to primitive type parameter '" + paramName + "'");
            }
            return null;
        }
        if (type == String.class) {
            result = value;
        } else if (type == Integer.TYPE || type == Integer.class) {
            result = new Integer(Integer.parseInt(value));
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            result = new Boolean(value);
        } else if (type == Byte.TYPE || type == Byte.class) {
            result = new Byte(Byte.parseByte(value));
        } else if (type == Character.TYPE || type == Character.class) {
            result = new Character(value.charAt(0));
        } else if (type == Double.TYPE || type == Double.class) {
            result = new Double(Double.parseDouble(value));
        } else if (type == Float.TYPE || type == Float.class) {
            result = new Float(Float.parseFloat(value));
        } else if (type == Long.TYPE || type == Long.class) {
            result = new Long(Long.parseLong(value));
        } else if (type == Short.TYPE || type == Short.class) {
            result = new Short(Short.parseShort(value));
        } else assert (false) : "Unsupported type parameter : " + type;
        return result;
    }

    public static Method findDataProvider(Class clazz, Method m, IAnnotationFinder finder) {
        String dataProviderName;
        Method result = null;
        ITest annotation = AnnotationHelper.findTest(finder, m);
        if (null != annotation && null != (dataProviderName = annotation.getDataProvider()) && !"".equals(dataProviderName)) {
            result = Parameters.findDataProvider(clazz, finder, dataProviderName, annotation.getDataProviderClass());
        }
        return result;
    }

    private static Method findDataProvider(Class cls, IAnnotationFinder finder, String name, Class dataProviderClass) {
        boolean shouldBeStatic = false;
        if (dataProviderClass != null) {
            cls = dataProviderClass;
            shouldBeStatic = true;
        }
        for (Method m : ClassHelper.getAvailableMethods(cls)) {
            IDataProvider dp = (IDataProvider)finder.findAnnotation(m, IDataProvider.class);
            if (null == dp || !name.equals(dp.getName()) && !name.equals(m.getName())) continue;
            if (shouldBeStatic && (m.getModifiers() & 8) == 0) {
                throw new TestNGException("DataProvider should be static: " + m);
            }
            return m;
        }
        return null;
    }

    private static Object[] createParameters(Method m, MethodParameters params, IAnnotationFinder finder, XmlSuite xmlSuite, Class annotationClass, String atName) {
        Object[] result = new Object[]{};
        IParameters annotation = (IParameters)finder.findAnnotation(m, IParameters.class);
        if (null != annotation) {
            String[] parameterNames = annotation.getValue();
            result = Parameters.createParameters(m.getName(), m.getParameterTypes(), atName, parameterNames, params, xmlSuite);
        } else {
            IParameterizable a = (IParameterizable)finder.findAnnotation(m, annotationClass);
            if (null != a) {
                String[] parameterNames = a.getParameters();
                result = Parameters.createParameters(m.getName(), m.getParameterTypes(), "@Configuration", parameterNames, params, xmlSuite);
            } else {
                Class[] paramTypes = m.getParameterTypes();
                if (paramTypes.length == 1 && Method.class.equals(paramTypes[0])) {
                    result = Parameters.createParameters(m.getName(), paramTypes, "@Configuration", new String[0], params, xmlSuite);
                }
            }
        }
        return result;
    }

    public static Iterator<Object[]> handleParameters(ITestNGMethod testMethod, Map<String, String> allParameterNames, ITestClass testClass, Map<String, String> parameters, XmlSuite xmlSuite, IAnnotationFinder annotationFinder) {
        Iterator<Object[]> result = null;
        Method dataProvider = Parameters.findDataProvider(testMethod.getTestClass().getRealClass(), testMethod.getMethod(), annotationFinder);
        if (null != dataProvider) {
            int parameterCount = testMethod.getMethod().getParameterTypes().length;
            for (int i = 0; i < parameterCount; ++i) {
                String n = "param" + i;
                allParameterNames.put(n, n);
            }
            boolean isStatic = (dataProvider.getModifiers() & 8) != 0;
            Object instance = isStatic ? null : testClass.getInstances(true)[0];
            result = MethodHelper.invokeDataProvider(instance, dataProvider, testMethod);
        } else {
            allParameterNames.putAll(parameters);
            Object[][] allParameterValuesArray = new Object[][]{Parameters.createTestParameters(testMethod.getMethod(), parameters, annotationFinder, xmlSuite)};
            testMethod.setParameterInvocationCount(allParameterValuesArray.length);
            result = MethodHelper.createArrayIterator(allParameterValuesArray);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodParameters {
        private final Map<String, String> m_parameters;
        private final Method m_currentTestMethod;

        public MethodParameters(Map<String, String> params) {
            this(params, null);
        }

        public MethodParameters(Map<String, String> params, Method m) {
            this.m_parameters = params;
            this.m_currentTestMethod = m;
        }
    }
}

