/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.ref.WeakReference;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.AspectFactoryWithClassLoader;

public abstract class AspectFactoryWithClassLoaderSupport
implements AspectFactory,
AspectFactoryWithClassLoader {
    private WeakReference loader;
    private ThreadLocal scopedClassLoader = new ThreadLocal();

    protected AspectFactoryWithClassLoaderSupport() {
    }

    public void setClassLoader(ClassLoader cl) {
        this.loader = new WeakReference<ClassLoader>(cl);
    }

    protected ClassLoader getLoader() {
        if (this.loader != null) {
            return (ClassLoader)this.loader.get();
        }
        return null;
    }

    public void pushScopedClassLoader(ClassLoader scopedCl) {
        this.scopedClassLoader.set(scopedCl);
    }

    public void popScopedClassLoader() {
        this.scopedClassLoader.set(null);
    }

    public ClassLoader peekScopedClassLoader() {
        return (ClassLoader)this.scopedClassLoader.get();
    }

    protected Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader cl = this.getLoader();
        if (cl == null) {
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            if (AspectManager.verbose) {
                System.out.println("Using context classloader " + tcl + " to load aspect " + name);
            }
            return tcl.loadClass(name);
        }
        if (AspectManager.verbose) {
            System.out.println("Using scoped classloader " + cl + " to load aspect " + name);
        }
        return cl.loadClass(name);
    }
}

