/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.io.File;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.AbstractStep;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.ext.mssql.InsertIdentityOperation;
import org.dbunit.operation.DatabaseOperation;
import org.dbunit.operation.TransactionOperation;

public class Operation
extends AbstractStep {
    private static final String DEFAULT_FORMAT = "flat";
    protected String _type = "CLEAN_INSERT";
    private String _format;
    private File _src;
    private boolean _transaction = false;
    private DatabaseOperation _operation;
    private boolean _forwardOperation = true;

    public String getType() {
        return this._type;
    }

    public File getSrc() {
        return this._src;
    }

    public DatabaseOperation getDbOperation() {
        return this._operation;
    }

    public String getFormat() {
        return this._format != null ? this._format : DEFAULT_FORMAT;
    }

    public boolean isTransaction() {
        return this._transaction;
    }

    public void setType(String type) {
        if ("UPDATE".equals(type)) {
            this._operation = DatabaseOperation.UPDATE;
            this._forwardOperation = true;
        } else if ("INSERT".equals(type)) {
            this._operation = DatabaseOperation.INSERT;
            this._forwardOperation = true;
        } else if ("REFRESH".equals(type)) {
            this._operation = DatabaseOperation.REFRESH;
            this._forwardOperation = true;
        } else if ("DELETE".equals(type)) {
            this._operation = DatabaseOperation.DELETE;
            this._forwardOperation = false;
        } else if ("DELETE_ALL".equals(type)) {
            this._operation = DatabaseOperation.DELETE_ALL;
            this._forwardOperation = false;
        } else if ("CLEAN_INSERT".equals(type)) {
            this._operation = DatabaseOperation.CLEAN_INSERT;
            this._forwardOperation = false;
        } else if ("NONE".equals(type)) {
            this._operation = DatabaseOperation.NONE;
            this._forwardOperation = true;
        } else if ("MSSQL_CLEAN_INSERT".equals(type)) {
            this._operation = InsertIdentityOperation.CLEAN_INSERT;
            this._forwardOperation = false;
        } else if ("MSSQL_INSERT".equals(type)) {
            this._operation = InsertIdentityOperation.INSERT;
            this._forwardOperation = true;
        } else if ("MSSQL_REFRESH".equals(type)) {
            this._operation = InsertIdentityOperation.REFRESH;
            this._forwardOperation = true;
        } else {
            throw new IllegalArgumentException("Type must be one of: UPDATE, INSERT, REFRESH, DELETE, DELETE_ALL, CLEAN_INSERT, MSSQL_INSERT,  or MSSQL_REFRESH but was: " + type);
        }
        this._type = type;
    }

    public void setSrc(File src) {
        this._src = src;
    }

    public void setFormat(String format) {
        if (!(format.equalsIgnoreCase(DEFAULT_FORMAT) || format.equalsIgnoreCase("xml") || format.equalsIgnoreCase("csv"))) {
            throw new IllegalArgumentException("Type must be either 'flat'(default), 'xml' or 'csv' but was: " + format);
        }
        this._format = format;
    }

    public void setTransaction(boolean transaction) {
        this._transaction = transaction;
    }

    public void execute(IDatabaseConnection connection) throws DatabaseUnitException {
        if (this._operation == null) {
            throw new DatabaseUnitException("Operation.execute(): setType(String) must be called before execute()!");
        }
        if (this._operation == DatabaseOperation.NONE) {
            return;
        }
        try {
            DatabaseOperation operation = this._transaction ? new TransactionOperation(this._operation) : this._operation;
            IDataSet dataset = this.getSrcDataSet(this.getSrc(), this.getFormat(), this._forwardOperation);
            operation.execute(connection, dataset);
        }
        catch (SQLException e) {
            throw new DatabaseUnitException(e);
        }
    }

    public String getLogMessage() {
        return "Executing operation: " + this._type + "\n          on   file: " + (this._src == null ? null : this._src.getAbsolutePath()) + "\n          with format: " + this._format;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Operation: ");
        result.append(" type=" + this._type);
        result.append(", format=" + this._format);
        result.append(", src=" + this._src == null ? null : this._src.getAbsolutePath());
        result.append(", operation = " + this._operation);
        return result.toString();
    }
}

