/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HttpServlet
extends GenericServlet
implements Serializable {
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        this.service(req, res);
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String method = req.getMethod();
        boolean isHead = false;
        if (method.equals("GET") || (isHead = method.equals("HEAD"))) {
            long requestLastModified;
            long lastModified = this.getLastModified(req);
            if (lastModified <= 0L) {
                if (isHead) {
                    this.doHead(req, res);
                } else {
                    this.doGet(req, res);
                }
                return;
            }
            char[] newETag = null;
            String etag = req.getHeader("If-None-Match");
            if (etag != null) {
                newETag = HttpServlet.generateETag(lastModified);
                int len = etag.length();
                if (len == newETag.length) {
                    --len;
                    while (len >= 0) {
                        if (etag.charAt(len) != newETag[len]) break;
                        --len;
                    }
                }
                if (len < 0) {
                    res.sendError(304);
                    return;
                }
            }
            if (lastModified / 1000L == (requestLastModified = req.getDateHeader("If-Modified-Since")) / 1000L) {
                res.sendError(304);
                return;
            }
            if (newETag == null) {
                newETag = HttpServlet.generateETag(lastModified);
            }
            res.setHeader("ETag", new String(newETag));
            res.setDateHeader("Last-Modified", lastModified);
            if (isHead) {
                this.doHead(req, res);
            } else {
                this.doGet(req, res);
            }
        } else if (method.equals("POST")) {
            this.doPost(req, res);
        } else if (method.equals("PUT")) {
            this.doPut(req, res);
        } else if (method.equals("DELETE")) {
            this.doDelete(req, res);
        } else if (method.equals("OPTIONS")) {
            this.doOptions(req, res);
        } else if (method.equals("TRACE")) {
            this.doTrace(req, res);
        } else {
            res.sendError(501, "Method not implemented");
        }
    }

    private static char[] generateETag(long data) {
        char[] buf = new char[]{'\"', HttpServlet.encodeBase64(data >> 60), HttpServlet.encodeBase64(data >> 54), HttpServlet.encodeBase64(data >> 48), HttpServlet.encodeBase64(data >> 42), HttpServlet.encodeBase64(data >> 36), HttpServlet.encodeBase64(data >> 30), HttpServlet.encodeBase64(data >> 24), HttpServlet.encodeBase64(data >> 18), HttpServlet.encodeBase64(data >> 12), HttpServlet.encodeBase64(data >> 6), HttpServlet.encodeBase64(data), '\"'};
        return buf;
    }

    private static char encodeBase64(long d) {
        if ((d &= 0x3FL) < 26L) {
            return (char)(d + 65L);
        }
        if (d < 52L) {
            return (char)(d + 97L - 26L);
        }
        if (d < 62L) {
            return (char)(d + 48L - 52L);
        }
        if (d == 62L) {
            return '+';
        }
        return '/';
    }

    protected long getLastModified(HttpServletRequest req) {
        return -1L;
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String protocol = req.getProtocol();
        String msg = req.getMethod() + " not supported";
        if (protocol.endsWith("1.1")) {
            res.sendError(405, msg);
        } else {
            res.sendError(400, msg);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String protocol = req.getProtocol();
        String msg = req.getMethod() + " not supported";
        if (protocol.endsWith("1.1")) {
            res.sendError(405, msg);
        } else {
            res.sendError(400, msg);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String protocol = req.getProtocol();
        String msg = req.getMethod() + " not supported";
        if (protocol.endsWith("1.1")) {
            res.sendError(405, msg);
        } else {
            res.sendError(400, msg);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String protocol = req.getProtocol();
        String msg = req.getMethod() + " not supported";
        if (protocol.endsWith("1.1")) {
            res.sendError(405, msg);
        } else {
            res.sendError(400, msg);
        }
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String protocol = req.getProtocol();
        String msg = req.getMethod() + " not supported";
        if (protocol.endsWith("1.1")) {
            res.sendError(405, msg);
        } else {
            res.sendError(400, msg);
        }
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String protocol = req.getProtocol();
        String msg = req.getMethod() + " not supported";
        if (protocol.endsWith("1.1")) {
            res.sendError(405, msg);
        } else {
            res.sendError(400, msg);
        }
    }
}

