/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;

public class OptimizedCallerInvocations
extends OptimizedBehaviourInvocations {
    protected static String createOptimizedMethodCalledByConInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtMethod method, int callingIndex, long calledHash) throws NotFoundException, CannotCompileException {
        AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation");
        boolean makeInnerClass = Modifier.isPrivate((int)method.getModifiers());
        CtClass invocation = OptimizedCallerInvocations.makeInvocationClass(pool, makeInnerClass, callingClass, className, methodInvocation);
        CtClass[] params = method.getParameterTypes();
        OptimizedCallerInvocations.addArgumentFieldsToInvocation(invocation, params);
        boolean isStatic = Modifier.isStatic((int)method.getModifiers());
        if (!isStatic) {
            CtField target = new CtField(method.getDeclaringClass(), "typedTargetObject", invocation);
            target.setModifiers(1);
            invocation.addField(target);
        }
        CtMethod in = methodInvocation.getDeclaredMethod("invokeNext");
        CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
        invokeNext.setModifiers(in.getModifiers());
        String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)      {         throw t;       }      finally      {         currentInterceptor--;       }   } ";
        String returnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ($w)";
        code = isStatic ? code + "   " + returnStr + " " + method.getDeclaringClass().getName() + "." : code + "   " + returnStr + " typedTargetObject.";
        code = code + method.getName() + "(";
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                code = code + ", ";
            }
            code = code + "arg" + i;
        }
        code = code + ");  ";
        if (method.getReturnType().equals(CtClass.voidType)) {
            code = code + " return null; ";
        }
        code = code + "}";
        try {
            invokeNext.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw e;
        }
        invocation.addMethod(invokeNext);
        OptimizedCallerInvocations.addGetArguments((ClassPool)pool, invocation, method.getParameterTypes());
        OptimizedCallerInvocations.addSetArguments((ClassPool)pool, invocation, method.getParameterTypes());
        CtMethod copyTemplate = methodInvocation.getDeclaredMethod("copy");
        CtMethod copy = CtNewMethod.make((CtClass)copyTemplate.getReturnType(), (String)"copy", (CtClass[])copyTemplate.getParameterTypes(), (CtClass[])copyTemplate.getExceptionTypes(), null, (CtClass)invocation);
        copy.setModifiers(copyTemplate.getModifiers());
        String copyCode = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.advisor, this.calling, this.method, this.targetObject, this.arguments, this.interceptors);" + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; " + "   wrapper.instanceResolver = this.instanceResolver; " + "   wrapper.targetObject = this.targetObject; " + "   wrapper.responseContextInfo = this.responseContextInfo; ";
        if (!isStatic) {
            copyCode = copyCode + "wrapper.typedTargetObject = typedTargetObject;";
        }
        for (int i = 0; i < params.length; ++i) {
            copyCode = copyCode + "   wrapper.arg" + i + " = this.arg" + i + "; ";
        }
        copyCode = copyCode + "   return wrapper; }";
        try {
            copy.setBody(copyCode);
        }
        catch (CannotCompileException e) {
            System.out.println(copyCode);
            throw e;
        }
        invocation.addMethod(copy);
        TransformerCommon.compileOrLoadClass(callingClass, invocation);
        return invocation.getName();
    }

    protected static String createOptimizedConCalledByConInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtConstructor con, int callingIndex, long calledHash) throws NotFoundException, CannotCompileException {
        AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
        CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation");
        boolean makeInnerClass = Modifier.isPrivate((int)con.getModifiers());
        CtClass invocation = OptimizedCallerInvocations.makeInvocationClass(pool, makeInnerClass, callingClass, className, conInvocation);
        CtClass[] params = con.getParameterTypes();
        OptimizedCallerInvocations.addArgumentFieldsToInvocation(invocation, params);
        CtMethod in = conInvocation.getDeclaredMethod("invokeNext");
        CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
        invokeNext.setModifiers(in.getModifiers());
        String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)      {         throw t;       }      finally      {         currentInterceptor--;       }   } ";
        code = code + "setTargetObject(new " + con.getDeclaringClass().getName() + "(";
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                code = code + ", ";
            }
            code = code + "arg" + i;
        }
        code = code + "));  ";
        code = code + "return getTargetObject();";
        code = code + "}";
        try {
            invokeNext.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw e;
        }
        invocation.addMethod(invokeNext);
        OptimizedCallerInvocations.addGetArguments((ClassPool)pool, invocation, con.getParameterTypes());
        OptimizedCallerInvocations.addSetArguments((ClassPool)pool, invocation, con.getParameterTypes());
        CtMethod copyTemplate = conInvocation.getDeclaredMethod("copy");
        CtMethod copy = CtNewMethod.make((CtClass)copyTemplate.getReturnType(), (String)"copy", (CtClass[])copyTemplate.getParameterTypes(), (CtClass[])copyTemplate.getExceptionTypes(), null, (CtClass)invocation);
        copy.setModifiers(copyTemplate.getModifiers());
        String copyCode = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.advisor, this.calling, this.constructor, this.wrappingMethod, this.arguments, this.interceptors);" + "   wrapper.metadata = super.metadata; " + "   wrapper.currentInterceptor = super.currentInterceptor; " + "   wrapper.instanceResolver = super.instanceResolver; " + "   wrapper.interceptors = super.interceptors; " + "   wrapper.responseContextInfo = super.responseContextInfo; " + "   wrapper.targetObject = super.targetObject; ";
        for (int i = 0; i < params.length; ++i) {
            copyCode = copyCode + "   wrapper.arg" + i + " = this.arg" + i + "; ";
        }
        copyCode = copyCode + "   return wrapper; }";
        try {
            copy.setBody(copyCode);
        }
        catch (CannotCompileException e) {
            System.out.println(copyCode);
            throw e;
        }
        invocation.addMethod(copy);
        TransformerCommon.compileOrLoadClass(callingClass, invocation);
        return invocation.getName();
    }

    protected static String createOptimizedConCalledByMethodInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtConstructor con, long callingHash, long calledHash) throws NotFoundException, CannotCompileException {
        AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
        CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation");
        boolean makeInnerClass = Modifier.isPrivate((int)con.getModifiers());
        CtClass invocation = OptimizedCallerInvocations.makeInvocationClass(pool, makeInnerClass, callingClass, className, conInvocation);
        CtClass[] params = con.getParameterTypes();
        OptimizedCallerInvocations.addArgumentFieldsToInvocation(invocation, params);
        CtMethod in = conInvocation.getDeclaredMethod("invokeNext");
        CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
        invokeNext.setModifiers(in.getModifiers());
        String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)      {         throw t;       }      finally      {         currentInterceptor--;       }   } ";
        code = code + "setTargetObject(new " + con.getDeclaringClass().getName() + "(";
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                code = code + ", ";
            }
            code = code + "arg" + i;
        }
        code = code + "));  ";
        code = code + "return getTargetObject();";
        code = code + "}";
        try {
            invokeNext.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw e;
        }
        invocation.addMethod(invokeNext);
        OptimizedCallerInvocations.addGetArguments((ClassPool)pool, invocation, con.getParameterTypes());
        OptimizedCallerInvocations.addSetArguments((ClassPool)pool, invocation, con.getParameterTypes());
        CtMethod copyTemplate = conInvocation.getDeclaredMethod("copy");
        CtMethod copy = CtNewMethod.make((CtClass)copyTemplate.getReturnType(), (String)"copy", (CtClass[])copyTemplate.getParameterTypes(), (CtClass[])copyTemplate.getExceptionTypes(), null, (CtClass)invocation);
        copy.setModifiers(copyTemplate.getModifiers());
        String copyCode = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.advisor, this.callingClass, this.callingMethod, this.constructor, this.wrappingMethod, this.callingObject, this.arguments, this.interceptors);" + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; " + "   wrapper.instanceResolver = this.instanceResolver; " + "   wrapper.targetObject = this.targetObject; " + "   wrapper.responseContextInfo = this.responseContextInfo; ";
        for (int i = 0; i < params.length; ++i) {
            copyCode = copyCode + "   wrapper.arg" + i + " = this.arg" + i + "; ";
        }
        copyCode = copyCode + "   return wrapper; }";
        try {
            copy.setBody(copyCode);
        }
        catch (CannotCompileException e) {
            System.out.println(copyCode);
            throw e;
        }
        invocation.addMethod(copy);
        TransformerCommon.compileOrLoadClass(callingClass, invocation);
        return invocation.getName();
    }

    protected static String createOptimizedMethodCalledByMethodInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtMethod method, long callingHash, long calledHash) throws NotFoundException, CannotCompileException {
        AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodCalledByMethodInvocation");
        boolean makeInnerClass = Modifier.isPrivate((int)method.getModifiers());
        CtClass invocation = OptimizedCallerInvocations.makeInvocationClass(pool, makeInnerClass, callingClass, className, methodInvocation);
        CtClass[] params = method.getParameterTypes();
        OptimizedCallerInvocations.addArgumentFieldsToInvocation(invocation, params);
        boolean isStatic = Modifier.isStatic((int)method.getModifiers());
        if (!isStatic) {
            CtField target = new CtField(method.getDeclaringClass(), "typedTargetObject", invocation);
            target.setModifiers(1);
            invocation.addField(target);
        }
        CtMethod in = methodInvocation.getDeclaredMethod("invokeNext");
        CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
        invokeNext.setModifiers(in.getModifiers());
        String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)      {         throw t;       }      finally      {         currentInterceptor--;       }   } ";
        String returnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ($w)";
        code = isStatic ? code + "   " + returnStr + " " + method.getDeclaringClass().getName() + "." : code + "   " + returnStr + " typedTargetObject.";
        code = code + method.getName() + "(";
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                code = code + ", ";
            }
            code = code + "arg" + i;
        }
        code = code + ");  ";
        if (method.getReturnType().equals(CtClass.voidType)) {
            code = code + " return null; ";
        }
        code = code + "}";
        try {
            invokeNext.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw e;
        }
        invocation.addMethod(invokeNext);
        OptimizedCallerInvocations.addGetArguments((ClassPool)pool, invocation, method.getParameterTypes());
        OptimizedCallerInvocations.addSetArguments((ClassPool)pool, invocation, method.getParameterTypes());
        CtMethod copyTemplate = methodInvocation.getDeclaredMethod("copy");
        CtMethod copy = CtNewMethod.make((CtClass)copyTemplate.getReturnType(), (String)"copy", (CtClass[])copyTemplate.getParameterTypes(), (CtClass[])copyTemplate.getExceptionTypes(), null, (CtClass)invocation);
        copy.setModifiers(copyTemplate.getModifiers());
        String copyCode = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.advisor, this.callingClass, this.callingMethod, this.method, this.callingObject, this.targetObject, this.arguments, this.interceptors);" + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; " + "   wrapper.instanceResolver = this.instanceResolver; " + "   wrapper.targetObject = this.targetObject; " + "   wrapper.responseContextInfo = this.responseContextInfo; ";
        if (!isStatic) {
            copyCode = copyCode + "wrapper.typedTargetObject = typedTargetObject;";
        }
        for (int i = 0; i < params.length; ++i) {
            copyCode = copyCode + "   wrapper.arg" + i + " = this.arg" + i + "; ";
        }
        copyCode = copyCode + "   return wrapper; }";
        try {
            copy.setBody(copyCode);
        }
        catch (CannotCompileException e) {
            System.out.println(copyCode);
            throw e;
        }
        invocation.addMethod(copy);
        TransformerCommon.compileOrLoadClass(callingClass, invocation);
        return invocation.getName();
    }
}

