/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.pojo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.tool.hbm2x.pojo.ImportContext;
import org.hibernate.util.StringHelper;

public class ImportContextImpl
implements ImportContext {
    Set imports = new TreeSet();
    Set staticImports = new TreeSet();
    Map simpleNames = new HashMap();
    String basePackage = "";
    private static final Map PRIMITIVES = new HashMap();

    public ImportContextImpl(String basePackage) {
        this.basePackage = basePackage;
    }

    public String importType(String fqcn) {
        String result = fqcn;
        String additionalTypePart = null;
        if (fqcn.indexOf(60) >= 0) {
            additionalTypePart = result.substring(fqcn.indexOf(60));
            fqcn = result = result.substring(0, fqcn.indexOf(60));
        } else if (fqcn.indexOf(91) >= 0) {
            additionalTypePart = result.substring(fqcn.indexOf(91));
            fqcn = result = result.substring(0, fqcn.indexOf(91));
        }
        boolean canBeSimple = true;
        String simpleName = StringHelper.unqualify((String)fqcn);
        if (this.simpleNames.containsKey(simpleName)) {
            String existingFqcn = (String)this.simpleNames.get(simpleName);
            canBeSimple = existingFqcn.equals(fqcn);
        } else {
            canBeSimple = true;
            this.simpleNames.put(simpleName, fqcn);
            this.imports.add(fqcn);
        }
        if (this.inSamePackage(fqcn) || this.imports.contains(fqcn) && canBeSimple) {
            result = StringHelper.unqualify((String)result);
        } else if (this.inJavaLang(fqcn)) {
            result = result.substring("java.lang.".length());
        }
        if (additionalTypePart != null) {
            return result + additionalTypePart;
        }
        return result;
    }

    public String staticImport(String fqcn, String member) {
        String local = fqcn + "." + member;
        this.imports.add(local);
        this.staticImports.add(local);
        if (member.equals("*")) {
            return "";
        }
        return member;
    }

    private boolean inDefaultPackage(String className) {
        return className.indexOf(".") < 0;
    }

    private boolean isPrimitive(String className) {
        return PRIMITIVES.containsKey(className);
    }

    private boolean inSamePackage(String className) {
        String other = StringHelper.qualifier((String)className);
        return other == this.basePackage || other != null && other.equals(this.basePackage);
    }

    private boolean inJavaLang(String className) {
        return "java.lang".equals(StringHelper.qualifier((String)className));
    }

    public String generateImports() {
        StringBuffer buf = new StringBuffer();
        Iterator imps = this.imports.iterator();
        while (imps.hasNext()) {
            String next = (String)imps.next();
            if (this.isPrimitive(next) || this.inDefaultPackage(next) || this.inJavaLang(next) || this.inSamePackage(next)) continue;
            if (this.staticImports.contains(next)) {
                buf.append("import static " + next + ";\r\n");
                continue;
            }
            buf.append("import " + next + ";\r\n");
        }
        return buf.toString();
    }

    static {
        PRIMITIVES.put("char", "Character");
        PRIMITIVES.put("byte", "Byte");
        PRIMITIVES.put("short", "Short");
        PRIMITIVES.put("int", "Integer");
        PRIMITIVES.put("long", "Long");
        PRIMITIVES.put("boolean", "Boolean");
        PRIMITIVES.put("float", "Float");
        PRIMITIVES.put("double", "Double");
    }
}

